/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IVariable;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WronglyNamedVariableRule
extends AbstractAstFlexRule {
    private static final String[] FORBIDDEN_NAMES = new String[]{"tmp", "temp", "foo", "bar", "object", "evt"};

    protected final void findViolations(List<IFunction> functions) {
        for (IFunction function : functions) {
            this.findViolationsInVariables(function.getParameters());
            for (Map.Entry variableNameEntrySet : function.getLocalVariables().entrySet()) {
                this.checkWronglyNamedVariable((String)variableNameEntrySet.getKey(), (IParserNode)variableNameEntrySet.getValue());
            }
        }
    }

    protected final void findViolationsFromAttributes(List<IAttribute> attributes) {
        this.findViolationsInVariables(attributes);
    }

    protected final void findViolationsFromConstants(List<IConstant> constants) {
        this.findViolationsInVariables(constants);
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void checkWronglyNamedVariable(String variableName, IParserNode variableNode) {
        for (String forbiddenName : FORBIDDEN_NAMES) {
            if (!variableName.startsWith(forbiddenName)) continue;
            this.addViolation(variableNode, new String[]{variableName});
        }
    }

    private void findViolationsInVariables(Collection<? extends IVariable> variables) {
        for (IVariable iVariable : variables) {
            this.checkWronglyNamedVariable(iVariable.getName(), iVariable.getInternalNode());
        }
    }
}

