/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INamableNode;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableNameEndingWithNumericRule
extends AbstractAstFlexRule {
    protected final void findViolations(IClass classNode) {
        super.findViolations(classNode);
        this.findViolationsInNamableList(classNode.getAttributes());
        this.findViolationsInNamableList(classNode.getConstants());
        this.findViolationsInNamableList(classNode.getFunctions());
    }

    protected final void findViolations(IFunction function) {
        this.findViolationsInNamableList(function.getParameters());
        for (String variableName : function.getLocalVariables().keySet()) {
            if (!this.isNameEndsWithNumeric(variableName)) continue;
            this.addViolation((IParserNode)function.getLocalVariables().get(variableName), new String[]{variableName});
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void findViolationsInNamableList(List<? extends INamableNode> namables) {
        for (INamableNode iNamableNode : namables) {
            if (!this.isNameEndsWithNumeric(iNamableNode.getName())) continue;
            if (iNamableNode instanceof IFunction) {
                IFunction function = (IFunction)iNamableNode;
                this.addViolation(function, function.getName());
                continue;
            }
            this.addViolation((INode)iNamableNode, new String[]{iNamableNode.getName()});
        }
    }

    private boolean isNameEndsWithNumeric(String name) {
        if (name.length() == 0) {
            return false;
        }
        char lastCharacter = name.charAt(name.length() - 1);
        return Character.isDigit(lastCharacter);
    }
}

