/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;
import java.util.Set;

public class PropertyHiddenByLocalVariableRule
extends AbstractAstFlexRule {
    protected final void findViolations(IClass classNode) {
        List variables = classNode.getAttributes();
        if (classNode.getFunctions() != null) {
            for (IFunction function : classNode.getFunctions()) {
                Set localVariables = function.getLocalVariables().keySet();
                for (String localVariable : localVariables) {
                    for (IAttribute field : variables) {
                        if (!localVariable.equals(field.getName())) continue;
                        this.addViolation((IParserNode)function.getLocalVariables().get(localVariable), new String[]{field.getName()});
                    }
                }
            }
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }
}

