/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;

public class PackageCaseRule
extends AbstractAstFlexRule {
    protected final void findViolations(IPackage packageNode) {
        if (this.containsUpperCharacter(packageNode.getName())) {
            IFlexViolation violation = this.addViolation((INode)packageNode, new String[]{packageNode.getName()});
            violation.setEndColumn(packageNode.getName().length() + violation.getBeginColumn());
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private boolean containsUpperCharacter(String packageName) {
        boolean found = false;
        for (int i = 1; i < packageName.length(); ++i) {
            char currentChar = packageName.charAt(i);
            if (currentChar < 'A' || currentChar > 'Z' || packageName.charAt(i - 1) != '.') continue;
            found = true;
            break;
        }
        return found;
    }
}

