/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapitalizeConstantsRule
extends AbstractAstFlexRule {
    protected void findViolationsFromConstants(List<IConstant> constants) {
        for (IConstant constant : constants) {
            if (!this.nameContainsLowerCase(constant.getName())) continue;
            this.addViolation((INode)constant, new String[]{constant.getName()});
        }
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private boolean nameContainsLowerCase(String name) {
        return name.toUpperCase().compareTo(name) != 0;
    }
}

