/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.naming;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INamableNode;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanAttributeShouldContainIsHasRule
extends AbstractAstFlexRule {
    private static final String BOOLEAN = "Boolean";
    private static final String[] FORBIDDEN_NAMES = new String[]{"has", "is", "can"};

    protected void findViolations(IFunction function) {
        if (function.isGetter() && function.isPublic() && function.getReturnType().toString().compareTo(BOOLEAN) == 0) {
            this.isWronglyNamed((INamableNode)function);
        }
    }

    protected void findViolationsFromAttributes(List<IAttribute> variables) {
        for (IAttribute variable : variables) {
            if (variable.getName().compareTo(BOOLEAN) != 0) continue;
            this.isWronglyNamed((INamableNode)variable);
        }
    }

    protected ViolationPriority getDefaultPriority() {
        return ViolationPriority.LOW;
    }

    private void isWronglyNamed(INamableNode namable) {
        for (String forbiddenName : FORBIDDEN_NAMES) {
            if (!namable.getName().startsWith(forbiddenName)) continue;
            return;
        }
        this.addViolation((INode)namable, new String[]{namable.getName()});
    }
}

