/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.mxml;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.core.thresholded.AbstractMaximizedFlexRule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooLongScriptBlockRule
extends AbstractMaximizedFlexRule {
    public static final int DEFAULT_THRESHOLD = 50;
    private int linesInScriptBlock;

    public final int getActualValueForTheCurrentViolation() {
        return this.linesInScriptBlock;
    }

    public final int getDefaultThreshold() {
        return 50;
    }

    public final boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().isMxml();
    }

    protected final List<IFlexViolation> findViolationsInCurrentFile() {
        ArrayList<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        IMxmlFile mxml = (IMxmlFile)this.getCurrentFile();
        this.linesInScriptBlock = mxml.getEndingScriptBlock() - mxml.getBeginningScriptBlock();
        if (this.linesInScriptBlock >= this.getThreshold()) {
            this.addViolation(violations, new ViolationPosition(mxml.getBeginningScriptBlock(), mxml.getEndingScriptBlock()));
        }
        return violations;
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }
}

