/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.mxml;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMoreThanEntryPointInMxmlRule
extends AbstractAstFlexRule {
    private int lastPublicVarLine = 0;
    private int publicVarCount = 0;

    AbstractMoreThanEntryPointInMxmlRule() {
    }

    public abstract int getThreshold();

    public final boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().isMxml();
    }

    protected void findViolations(IClass classNode) {
        this.publicVarCount = 0;
        this.lastPublicVarLine = 0;
        super.findViolations(classNode);
        if (this.publicVarCount > this.getThreshold()) {
            this.addViolation(ViolationPosition.create((int)this.lastPublicVarLine, (int)this.lastPublicVarLine, (int)0, (int)this.getCurrentFile().getLineAt(this.lastPublicVarLine - 1).length()));
        }
    }

    protected final void findViolations(IFunction function) {
        if (function.isPublic() && function.isSetter()) {
            ++this.publicVarCount;
            this.lastPublicVarLine = function.getInternalNode().getLine();
        }
    }

    protected void findViolationsFromAttributes(List<IAttribute> variables) {
        for (IAttribute attribute : variables) {
            if (!attribute.isPublic()) continue;
            ++this.publicVarCount;
            this.lastPublicVarLine = attribute.getInternalNode().getLine();
        }
    }
}

