/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.maintanability.forbiddentypes;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IVariable;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUseForbiddenTypeRule
extends AbstractAstFlexRule {
    protected void findViolations(IClass classNode) {
        super.findViolations(classNode);
        this.findViolationInVariableLists(classNode.getAttributes());
        this.findViolationInVariableLists(classNode.getConstants());
    }

    protected void findViolations(IFunction function) {
        this.findViolationsInReturnType(function);
        if (!function.isOverriden()) {
            this.findViolationsInParametersList(function);
        }
        this.findViolationsInLocalVariables(function);
    }

    protected void findViolationsInParametersList(IFunction function) {
        this.findViolationInVariableLists(function.getParameters());
    }

    protected abstract String getForbiddenType();

    private <E extends IVariable> void findViolationInVariableLists(List<E> variables) {
        for (IVariable variable : variables) {
            if (variable.getType() == null) continue;
            this.tryToAddViolation(variable.getInternalNode(), variable.getType().toString());
        }
    }

    private void findViolationsInLocalVariables(IFunction function) {
        for (Map.Entry localVariableEntry : function.getLocalVariables().entrySet()) {
            IParserNode type = AbstractUseForbiddenTypeRule.getTypeFromFieldDeclaration((IParserNode)((IParserNode)localVariableEntry.getValue()));
            this.tryToAddViolation(type, type.getStringValue());
        }
    }

    private void findViolationsInReturnType(IFunction function) {
        this.tryToAddViolation(function.getReturnType().getInternalNode(), function.getReturnType().toString());
    }

    private void tryToAddViolation(IParserNode node, String typeName) {
        if (typeName.equals(this.getForbiddenType())) {
            this.addViolation(node);
        }
    }
}

