/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.maintanability;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidProtectedFieldInFinalClassRule
extends AbstractAstFlexRule {
    protected final void findViolations(IClass classNode) {
        boolean isClassFinal = classNode.isFinal();
        this.findProtectedAttributes(classNode.getAttributes(), isClassFinal);
        this.findProtectedMethods(classNode.getFunctions(), isClassFinal);
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.LOW;
    }

    private void findProtectedAttributes(List<IAttribute> atributes, boolean isClassFinal) {
        if (atributes != null) {
            for (IAttribute field : atributes) {
                if (!field.is(Modifier.PROTECTED) || !isClassFinal) continue;
                this.addViolation((INode)field, new String[]{field.getName()});
            }
        }
    }

    private void findProtectedMethods(List<IFunction> functions, boolean isClassFinal) {
        if (functions != null) {
            for (IFunction function : functions) {
                if (!function.is(Modifier.PROTECTED) || function.isOverriden() || !isClassFinal) continue;
                this.addViolation(function);
            }
        }
    }
}

