/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.maintanability;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IField;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFieldWithNoArrayElementTypeRule
extends AbstractAstFlexRule {
    private static final String ARRAY_TYPE = "Array";

    public boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().isMxml();
    }

    protected final void findViolationsFromAttributes(List<IAttribute> variables) {
        this.findViolationFromFieds(variables);
    }

    protected void findViolationsFromConstants(List<IConstant> constants) {
        this.findViolationFromFieds(constants);
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private void findViolationFromFieds(List<? extends IField> fields) {
        for (IField iField : fields) {
            if (!ARRAY_TYPE.equals(iField.getType().toString()) || iField.getMetaData(MetaData.ARRAY_ELEMENT_TYPE) != null) continue;
            this.addViolation((INode)iField, new String[]{iField.getName()});
        }
    }
}

