/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.cairngorm;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatControllerRule
extends AbstractAstFlexRule {
    public final boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().getClassName().endsWith("Controller.as");
    }

    protected final void findViolations(IPackage packageNode) {
        IClass classNode = packageNode.getClassNode();
        if (classNode != null) {
            int commandsCount = this.computeCommandsCountInImport(packageNode.getImports());
            int methodsCount = classNode.getFunctions().size();
            if (methodsCount > 0 && commandsCount / methodsCount > 5) {
                this.addViolation((INode)classNode);
            }
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private int computeCommandsCountInImport(List<IParserNode> imports) {
        int commandImport = 0;
        if (imports != null) {
            for (IParserNode importNode : imports) {
                if (!importNode.getStringValue().endsWith("Command")) continue;
                ++commandImport;
            }
        }
        return commandImport;
    }
}

