/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.cairngorm;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import org.apache.commons.lang.StringUtils;

public class BadCairngormEventNameFormatRule
extends AbstractAstFlexRule {
    public final boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().getClassName().endsWith("Event.as");
    }

    protected final void findViolations(IClass classNode) {
        String eventName;
        if (this.isExtendedClassCairngormEvent(classNode) && (StringUtils.isEmpty((String)(eventName = this.extractEventName(classNode))) || !eventName.contains("."))) {
            this.addViolation((INode)classNode);
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    private String extractEventName(IClass classNode) {
        String eventName = "";
        for (IConstant constantNode : classNode.getConstants()) {
            if (!constantNode.getName().startsWith("EVENT")) continue;
            eventName = this.extractEventNameFromConstant(constantNode.getInitializationExpression().getInternalNode());
        }
        if (StringUtils.isEmpty((String)eventName) && classNode.getConstructor() != null) {
            eventName = this.extractEventNameFromConstructor(classNode.getConstructor());
        }
        return eventName;
    }

    private String extractEventNameFromConstant(IParserNode initExpressionNode) {
        return initExpressionNode.getChild(0).getStringValue();
    }

    private String extractEventNameFromConstructor(IFunction constructor) {
        String eventName = "";
        IParserNode superCall = constructor.getSuperCall();
        if (superCall != null) {
            eventName = superCall.getChild(1).getChild(0).getStringValue();
        }
        return eventName;
    }

    private boolean isExtendedClassCairngormEvent(IClass classNode) {
        return classNode.getExtensionName() != null && classNode.getExtensionName().contains("Cairngorm") && classNode.getExtensionName().contains("Event");
    }
}

