/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.architecture;

import com.adobe.ac.pmd.rules.core.AbstractRegexpBasedRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.util.Locale;
import java.util.regex.Matcher;

public class ViewComponentReferencedInModelRule
extends AbstractRegexpBasedRule {
    private static final String ALERT_CLASS_NAME = "Alert";
    private static final String FLEX_CONTROLS_PACKAGE_NAME = "mx.controls";
    private static final String MODEL_CLASS_SUFFIX = "model";
    private static final String MODEL_PACKAGE_NAME = ".model";
    private static final String VIEW_PACKAGE_NAME = ".view";

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.NORMAL;
    }

    protected final String getRegexp() {
        return ".*import (.*);?.*";
    }

    protected final boolean isConcernedByTheCurrentFile() {
        return !this.getCurrentFile().isMxml() && this.getCurrentFile().getFullyQualifiedName().toLowerCase(Locale.ENGLISH).contains(MODEL_CLASS_SUFFIX);
    }

    protected final boolean isViolationDetectedOnThisMatchingLine(String line) {
        Matcher matcher = this.getMatcher(line);
        matcher.matches();
        String importedClass = matcher.group(1);
        return importedClass.contains(FLEX_CONTROLS_PACKAGE_NAME) && !importedClass.contains(ALERT_CLASS_NAME) || importedClass.contains(VIEW_PACKAGE_NAME) && !importedClass.contains(MODEL_PACKAGE_NAME);
    }
}

