/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.architecture;

import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.rules.core.AbstractAstFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import org.apache.commons.lang.StringUtils;

public class UseInternalClassOutsideApiClass
extends AbstractAstFlexRule {
    private static final String API_PACKAGE_NAME = "api";
    private static final String INTERNAL_PACKAGE_NAME = "restricted";
    private static final String PACKAGE_SEPARATOR = ".";

    protected final void findViolations(IPackage packageNode) {
        String packageName = packageNode.getName();
        boolean isApiClass = this.isApiClass(packageName);
        boolean isInternalClass = this.isInternalClass(packageName);
        String functionAreaName = null;
        if (isApiClass || isInternalClass) {
            functionAreaName = this.extractFunctionalArea(packageName, false);
        }
        for (IParserNode importNode : packageNode.getImports()) {
            String importName = importNode.getStringValue();
            String importFunctionalArea = this.extractFunctionalArea(importName, true);
            if (!this.doesLineContainPackageReference(importName, INTERNAL_PACKAGE_NAME) || functionAreaName != null && functionAreaName.equals(importFunctionalArea)) continue;
            this.addViolation(importNode, new String[]{importName, importFunctionalArea});
        }
    }

    protected final ViolationPriority getDefaultPriority() {
        return ViolationPriority.HIGH;
    }

    private boolean doesLineContainPackageReference(String line, String packageName) {
        return line.contains(PACKAGE_SEPARATOR + packageName);
    }

    private String extractFunctionalArea(String packageName, boolean isInImport) {
        if (packageName.contains(INTERNAL_PACKAGE_NAME)) {
            return this.extractFunctionArea(packageName, INTERNAL_PACKAGE_NAME, isInImport);
        }
        return this.extractFunctionArea(packageName, API_PACKAGE_NAME, isInImport);
    }

    private String extractFunctionArea(String packageName, String visibilityPackageName, boolean isInImport) {
        return StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)packageName, (String)(PACKAGE_SEPARATOR + visibilityPackageName + (isInImport ? PACKAGE_SEPARATOR : ""))), (String)PACKAGE_SEPARATOR);
    }

    private boolean isApiClass(String packageName) {
        return this.doesLineContainPackageReference(packageName, API_PACKAGE_NAME);
    }

    private boolean isInternalClass(String packageName) {
        return this.doesLineContainPackageReference(packageName, INTERNAL_PACKAGE_NAME);
    }
}

