/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.ncss.utils;

import com.adobe.ac.utils.StackTraceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    public static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static boolean isLineACorrectStatement(String line) {
        return line.compareTo("") != 0 && FileUtils.lrtrim(line).compareTo("{") != 0 && FileUtils.lrtrim(line).compareTo("}") != 0 && line.endsWith(";");
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        return FileUtils.listFilesRecurse(directory, filter, recurse);
    }

    public static Collection<File> listFiles(List<File> sourceDirectory, FilenameFilter filter, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        for (File topDirectory : sourceDirectory) {
            files.addAll(FileUtils.listFilesRecurse(topDirectory, filter, recurse));
        }
        return files;
    }

    public static List<String> readFile(File file) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader inReader = null;
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            inReader = new BufferedReader(reader);
            String line = FileUtils.readLine(inReader);
            while (line != null) {
                result.add(line);
                line = FileUtils.readLine(inReader);
            }
            inReader.close();
        }
        catch (IOException e) {
            StackTraceUtils.print(e);
        }
        return result;
    }

    private static Collection<File> listFilesRecurse(File directory, FilenameFilter filter, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        File[] entries = directory.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                if (filter == null || filter.accept(directory, entry.getName())) {
                    files.add(entry);
                }
                if (!recurse || !entry.isDirectory()) continue;
                files.addAll(FileUtils.listFilesRecurse(entry, filter, recurse));
            }
        }
        return files;
    }

    private static String lrtrim(String source) {
        return FileUtils.ltrim(FileUtils.rtrim(source));
    }

    private static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    private static String readLine(BufferedReader inReader) throws IOException {
        String line = inReader.readLine();
        if (line != null) {
            return line.replaceAll("\ufeff", "");
        }
        return null;
    }

    private static String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    private FileUtils() {
    }
}

