/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.engines;

import com.adobe.ac.pmd.FlexPmdViolations;
import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public final class PmdEngineUtils {
    public static String findFirstViolationError(FlexPmdViolations violations) {
        StringBuffer buffer = new StringBuffer();
        String message = "An error violation has been found on the file {0} at line {1}, with the rule \"{2}\": {3}";
        MessageFormat form = new MessageFormat("An error violation has been found on the file {0} at line {1}, with the rule \"{2}\": {3}");
        for (Map.Entry<IFlexFile, List<IFlexViolation>> violatedFile : violations.getViolations().entrySet()) {
            for (IFlexViolation violation : violatedFile.getValue()) {
                if (violation.getRule().getPriority() != Integer.parseInt(ViolationPriority.HIGH.toString())) continue;
                String[] formatArgument = PmdEngineUtils.computeArgumentFormat(violation);
                buffer.append(form.format(formatArgument));
                buffer.append('\n');
            }
        }
        return buffer.toString();
    }

    private static String[] computeArgumentFormat(IFlexViolation violation) {
        String[] formatArgument = new String[]{violation.getFilename(), String.valueOf(violation.getBeginLine()), violation.getRule().getRuleClass(), violation.getRuleMessage()};
        return formatArgument;
    }

    private PmdEngineUtils() {
    }
}

