/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.engines;

import com.adobe.ac.pmd.FlexPmdParameters;
import com.adobe.ac.pmd.FlexPmdViolations;
import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.engines.AbstractFlexPmdEngine;
import com.adobe.ac.pmd.engines.FlexPMDFormat;
import com.adobe.ac.pmd.files.IFlexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexPmdXmlEngine
extends AbstractFlexPmdEngine {
    private static final Logger LOGGER = Logger.getLogger(FlexPmdXmlEngine.class.getName());

    public FlexPmdXmlEngine(FlexPmdParameters parameters) throws URISyntaxException, IOException {
        super(parameters);
    }

    @Override
    protected final void writeReport(FlexPmdViolations pmd) throws PMDException {
        File realOutputDirectory = this.getOutputDirectory();
        String filePath = realOutputDirectory.getAbsoluteFile() + File.separator + FlexPMDFormat.XML.toString();
        this.makeSureOutputDirectoryExists(realOutputDirectory);
        OutputStreamWriter writter = null;
        try {
            LOGGER.finest("Start writting XML report");
            LOGGER.info("Creating report in <" + filePath + ">");
            writter = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
            this.writeReportHeader(writter);
            this.writeFileViolations(pmd, writter);
            this.writeReportFooter(writter);
            ((Writer)writter).close();
            this.finalizeReport(writter);
        }
        catch (IOException e) {
            try {
                throw new PMDException("Error creating file " + filePath, (Exception)e);
            }
            catch (Throwable throwable) {
                this.finalizeReport(writter);
                throw throwable;
            }
        }
    }

    private void finalizeReport(Writer writter) {
        LOGGER.finest("End writting XML report");
        if (writter != null) {
            try {
                LOGGER.finest("Closing the XML writter");
                writter.close();
            }
            catch (IOException e) {
                LOGGER.warning(Arrays.toString(e.getStackTrace()));
            }
            LOGGER.finest("Closed the XML writter");
        }
    }

    private void formatFileFiolation(Writer writter, IFlexFile sourceFile, Collection<IFlexViolation> violations, String sourceFilePath) throws IOException {
        if (!violations.isEmpty()) {
            if (sourceFilePath.charAt(2) == ':') {
                writter.write("   <file name=\"" + sourceFilePath.substring(1, sourceFilePath.length()) + "\">" + this.getNewLine());
            } else {
                writter.write("   <file name=\"" + sourceFilePath + "\">" + this.getNewLine());
            }
            for (IFlexViolation violation : violations) {
                writter.write(violation.toXmlString(sourceFile, violation.getRule().getRuleSetName()));
            }
            writter.write("   </file>" + this.getNewLine());
        }
    }

    private String getNewLine() {
        return System.getProperty("line.separator");
    }

    private void makeSureOutputDirectoryExists(File realOutputDirectory) {
        if (!realOutputDirectory.exists() && !realOutputDirectory.mkdirs()) {
            LOGGER.severe("Unable to create an output folder");
        }
    }

    private void writeFileViolations(FlexPmdViolations pmd, Writer writter) throws IOException {
        for (IFlexFile sourceFile : pmd.getViolations().keySet()) {
            Collection violations = pmd.getViolations().get(sourceFile);
            String sourceFilePath = sourceFile.getFilePath();
            this.formatFileFiolation(writter, sourceFile, violations, sourceFilePath);
        }
    }

    private void writeReportFooter(Writer writter) throws IOException {
        writter.write("</pmd>" + this.getNewLine());
    }

    private void writeReportHeader(Writer writter) throws IOException {
        writter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.getNewLine());
        writter.write("<pmd version=\"4.2.1\" timestamp=\"" + new Date().toString() + "\">" + this.getNewLine());
    }
}

