/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.engines;

import com.adobe.ac.pmd.FlexPmdParameters;
import com.adobe.ac.pmd.FlexPmdViolations;
import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.utils.StackTraceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractFlexPmdEngine {
    private static final Logger LOGGER = Logger.getLogger(AbstractFlexPmdEngine.class.getName());
    private final File outputDirectory;
    private final String packageToExclude;
    private RuleSet ruleSet;
    private final File source;
    private final List<File> sourceList;

    private static int computeViolationNumber(FlexPmdViolations flexPmdViolations) {
        int foundViolations = 0;
        for (List<IFlexViolation> violations : flexPmdViolations.getViolations().values()) {
            foundViolations += violations.size();
        }
        LOGGER.info("Violations number found: " + foundViolations);
        return foundViolations;
    }

    private static File extractDefaultRuleSet() throws URISyntaxException, IOException {
        String rulesetURI = "/com/adobe/ac/pmd/default_flex.xml";
        InputStream resourceAsStream = AbstractFlexPmdEngine.class.getResourceAsStream("/com/adobe/ac/pmd/default_flex.xml");
        File temporaryRuleset = File.createTempFile("default_flex", ".xml");
        temporaryRuleset.deleteOnExit();
        FileOutputStream writter = new FileOutputStream(temporaryRuleset);
        IOUtil.copy((InputStream)resourceAsStream, (OutputStream)writter);
        resourceAsStream.close();
        return temporaryRuleset;
    }

    public AbstractFlexPmdEngine(FlexPmdParameters parameters) {
        this.source = parameters.getSource();
        this.sourceList = parameters.getSourceList();
        this.outputDirectory = parameters.getOutputDirectory();
        this.packageToExclude = parameters.getExcludePackage();
        try {
            this.ruleSet = this.loadRuleset(parameters.getRuleSet());
        }
        catch (URISyntaxException e) {
            LOGGER.warning(StackTraceUtils.print((Exception)e));
        }
        catch (IOException e) {
            LOGGER.warning(StackTraceUtils.print((Exception)e));
        }
    }

    public final void executeReport(FlexPmdViolations flexPmdViolations) throws PMDException {
        if (this.source == null && this.sourceList == null) {
            throw new PMDException("unspecified sourceDirectory");
        }
        if (this.outputDirectory == null) {
            throw new PMDException("unspecified outputDirectory");
        }
        if (this.ruleSet != null) {
            if (!flexPmdViolations.hasViolationsBeenComputed()) {
                this.computeViolations(flexPmdViolations);
            }
            AbstractFlexPmdEngine.computeViolationNumber(flexPmdViolations);
            this.writeAnyReport(flexPmdViolations);
        }
    }

    public final RuleSet getRuleSet() {
        return this.ruleSet;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected abstract void writeReport(FlexPmdViolations var1) throws PMDException;

    private void computeViolations(FlexPmdViolations flexPmdViolations) throws PMDException {
        long startTime = System.currentTimeMillis();
        flexPmdViolations.computeViolations(this.source, this.sourceList, this.ruleSet, this.packageToExclude);
        long ellapsedTime = System.currentTimeMillis() - startTime;
        LOGGER.info("It took " + ellapsedTime + "ms to compute violations");
    }

    private File extractRuleset(File ruleSetFile) throws URISyntaxException, IOException {
        return ruleSetFile == null ? AbstractFlexPmdEngine.extractDefaultRuleSet() : ruleSetFile;
    }

    private String getReportType() {
        return StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.getClass().getName(), (String)"FlexPmd"), (String)"Engine");
    }

    private RuleSet loadRuleset(File ruleSetFile) throws URISyntaxException, IOException {
        File realRuleSet = this.extractRuleset(ruleSetFile);
        FileInputStream inputStream = new FileInputStream(realRuleSet);
        RuleSet loadedRuleSet = new RuleSetFactory().createRuleSet((InputStream)inputStream);
        LOGGER.info("Ruleset: " + realRuleSet.getAbsolutePath());
        LOGGER.info("Rules number in the ruleSet: " + loadedRuleSet.getRules().size());
        inputStream.close();
        return loadedRuleSet;
    }

    private void writeAnyReport(FlexPmdViolations flexPmdViolations) throws PMDException {
        long startTime = System.currentTimeMillis();
        this.writeReport(flexPmdViolations);
        long ellapsedTime = System.currentTimeMillis() - startTime;
        LOGGER.info("It took " + ellapsedTime + "ms to write the " + this.getReportType() + " report");
    }
}

