/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.FileSetUtils;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.rules.core.IFlexAstRule;
import com.adobe.ac.pmd.rules.core.IFlexRule;
import com.adobe.ac.utils.StackTraceUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.RuleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexPmdViolations
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(FlexPmdViolations.class.getName());
    private static final long serialVersionUID = -3683680443330143504L;
    private Map<String, IPackage> asts;
    private Map<String, IFlexFile> files;
    private boolean hasBeenComputed = false;
    private final Map<String, IFlexRule> rules;
    private final Map<IFlexRule, Long> ruleSpeeds;
    private final Map<IFlexFile, List<IFlexViolation>> violations = new LinkedHashMap<IFlexFile, List<IFlexViolation>>();

    public FlexPmdViolations() {
        this.rules = new LinkedHashMap<String, IFlexRule>();
        this.ruleSpeeds = new LinkedHashMap<IFlexRule, Long>();
    }

    public final void computeViolations(File source, List<File> sourceList, RuleSet ruleSet, String packageToExclude) throws PMDException {
        this.hasBeenComputed = true;
        if (ruleSet != null) {
            this.computeRules(ruleSet);
            this.computeFiles(source, sourceList, packageToExclude, ruleSet.getExcludePatterns());
            this.computeAsts();
            this.processRules();
            this.sortViolations();
        }
    }

    public final Map<IFlexFile, List<IFlexViolation>> getViolations() {
        return this.violations;
    }

    public final boolean hasViolationsBeenComputed() {
        return this.hasBeenComputed;
    }

    private void computeAsts() throws PMDException {
        LOGGER.info("computing Asts");
        long startTime = System.currentTimeMillis();
        this.asts = FileSetUtils.computeAsts(this.files);
        LOGGER.info("computed Asts in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void computeFiles(File source, List<File> sourceList, String packageToExclude, List<String> excludePatterns) throws PMDException {
        LOGGER.info("computing FilesList");
        long startTime = System.currentTimeMillis();
        this.files = FileUtils.computeFilesList((File)source, sourceList, (String)packageToExclude, excludePatterns);
        LOGGER.info("computed FilesList in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void computeRules(RuleSet ruleSet) {
        LOGGER.info("computing RulesList");
        long startTime = System.currentTimeMillis();
        Set excludes = new HashSet(ruleSet.getExcludePatterns());
        for (Rule rule : ruleSet.getRules()) {
            while (rule instanceof RuleReference) {
                excludes = ((RuleReference)rule).getRuleSetReference().getExcludes();
                rule = ((RuleReference)rule).getRule();
            }
            IFlexRule flexRule = (IFlexRule)rule;
            if (excludes != null && !excludes.isEmpty()) {
                flexRule.setExcludes(excludes);
            }
            this.rules.put(flexRule.getRuleName(), flexRule);
        }
        LOGGER.info("computed RulesList in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void processFile(IFlexRule currentRule, IFlexFile currentFile) {
        try {
            String fullyQualifiedName = currentFile.getFullyQualifiedName();
            IPackage ast = currentRule instanceof IFlexAstRule ? this.asts.get(fullyQualifiedName) : null;
            List foundViolations = currentRule.processFile(currentFile, ast, this.files);
            if (!foundViolations.isEmpty()) {
                if (this.violations.containsKey(currentFile)) {
                    this.violations.get(currentFile).addAll(foundViolations);
                } else {
                    this.violations.put(currentFile, foundViolations);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning(StackTraceUtils.print((String)currentFile.getFullyQualifiedName(), (Exception)e));
        }
    }

    private void processRule(IFlexRule currentRule) {
        LOGGER.fine("Processing " + currentRule.getRuleName() + "...");
        for (Map.Entry<String, IFlexFile> currentFileEntry : this.files.entrySet()) {
            this.processFile(currentRule, currentFileEntry.getValue());
        }
    }

    private void processRule(String currentRuleName, IFlexRule currentRule) {
        long startTime = System.currentTimeMillis();
        this.processRule(currentRule);
        long ellapsedTime = System.currentTimeMillis() - startTime;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("rule " + currentRuleName + " computed in " + ellapsedTime + "ms");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            this.ruleSpeeds.put(currentRule, ellapsedTime);
        }
    }

    private void processRules() {
        for (Map.Entry<String, IFlexRule> currentRuleEntry : this.rules.entrySet()) {
            this.processRule(currentRuleEntry.getKey(), currentRuleEntry.getValue());
        }
    }

    private void sortViolations() {
        for (Map.Entry<String, IFlexFile> entry : this.files.entrySet()) {
            if (!this.violations.containsKey(entry.getValue())) continue;
            Collections.sort(this.violations.get(entry.getValue()));
        }
    }

    static {
        LOGGER.setLevel(Level.WARNING);
    }
}

