/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.commandline;

import com.adobe.ac.pmd.CommandLineOptions;
import com.adobe.ac.pmd.CommandLineUtils;
import com.adobe.ac.pmd.FlexPmdParameters;
import com.adobe.ac.pmd.FlexPmdViolations;
import com.adobe.ac.pmd.ICommandLineOptions;
import com.adobe.ac.pmd.engines.FlexPmdXmlEngine;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;

public final class FlexPMD {
    private static JSAPResult config;
    private static final Logger LOGGER;

    public static void main(String[] args) throws JSAPException, PMDException, URISyntaxException, IOException {
        LOGGER.setLevel(Level.SEVERE);
        FlexPMD.startFlexPMD(args);
        LOGGER.info("FlexPMD terminated");
        System.exit(0);
    }

    static boolean areCommandLineOptionsCorrect(String[] args) throws JSAPException {
        JSAP jsap = new JSAP();
        config = FlexPMD.parseCommandLineArguments(args, jsap);
        if (!config.success()) {
            LOGGER.log(Level.SEVERE, "Usage: java " + FlexPMD.class.getName() + " " + jsap.getUsage());
        }
        return config.success();
    }

    static String getParameterValue(CommandLineOptions option) {
        return config.getString(option.toString());
    }

    static boolean startFlexPMD(String[] args) throws JSAPException, PMDException, URISyntaxException, IOException {
        if (FlexPMD.areCommandLineOptionsCorrect(args)) {
            String rulesetRef = FlexPMD.getParameterValue(CommandLineOptions.RULE_SET);
            String excludePackage = FlexPMD.getParameterValue(CommandLineOptions.EXLUDE_PACKAGE);
            String source = FlexPMD.getParameterValue(CommandLineOptions.SOURCE_DIRECTORY);
            File sourceDirectory = source.contains(",") ? null : new File(source);
            List sourceList = CommandLineUtils.computeSourceList((String)source);
            File outputDirectory = new File(FlexPMD.getParameterValue(CommandLineOptions.OUTPUT));
            FlexPmdParameters parameters = new FlexPmdParameters(excludePackage == null ? "" : excludePackage, outputDirectory, rulesetRef == null ? null : new File(rulesetRef), sourceDirectory, sourceList);
            FlexPmdXmlEngine engine = new FlexPmdXmlEngine(parameters);
            engine.executeReport(new FlexPmdViolations());
        }
        return config.success();
    }

    private static JSAPResult parseCommandLineArguments(String[] args, JSAP jsap) throws JSAPException {
        CommandLineUtils.registerParameter((JSAP)jsap, (ICommandLineOptions)CommandLineOptions.SOURCE_DIRECTORY, (boolean)true);
        CommandLineUtils.registerParameter((JSAP)jsap, (ICommandLineOptions)CommandLineOptions.OUTPUT, (boolean)true);
        CommandLineUtils.registerParameter((JSAP)jsap, (ICommandLineOptions)CommandLineOptions.RULE_SET, (boolean)false);
        CommandLineUtils.registerParameter((JSAP)jsap, (ICommandLineOptions)CommandLineOptions.EXLUDE_PACKAGE, (boolean)false);
        return jsap.parse(args);
    }

    private FlexPMD() {
    }

    static {
        LOGGER = Logger.getLogger(FlexPMD.class.getName());
    }
}

