/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.files.impl;

import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.files.impl.AbstractFlexFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MxmlFile
extends AbstractFlexFile
implements IMxmlFile {
    private static final String METADATA_TAG = "Metadata>";
    private String[] actualScriptBlock;
    private int endLine;
    private boolean mainApplication = false;
    private String[] scriptBlock;
    private int startLine;

    protected MxmlFile(File file, File rootDirectory) {
        super(file, rootDirectory);
        this.computeIfIsMainApplication();
        if (this.getLinesNb() > 0) {
            this.extractScriptBlock();
        }
    }

    @Override
    public final String[] getActualScriptBlock() {
        return this.actualScriptBlock;
    }

    @Override
    public int getBeginningScriptBlock() {
        return this.startLine;
    }

    @Override
    public final String getCommentClosingTag() {
        return "-->";
    }

    @Override
    public final String getCommentOpeningTag() {
        return "<!--";
    }

    @Override
    public int getEndingScriptBlock() {
        return this.endLine;
    }

    @Override
    public final String[] getScriptBlock() {
        return this.scriptBlock;
    }

    @Override
    public String getSingleLineComment() {
        return this.getCommentOpeningTag();
    }

    @Override
    public final boolean isMainApplication() {
        return this.mainApplication;
    }

    @Override
    public final boolean isMxml() {
        return true;
    }

    private void computeIfIsMainApplication() {
        for (String line : this.getLines()) {
            if (!line.contains("Application ") || line.charAt(0) != '<') continue;
            this.mainApplication = true;
            break;
        }
    }

    private int computeScriptOffSet(int startingLineIndex) {
        int currentLineIndex = startingLineIndex + 1;
        while (this.getLines().get(currentLineIndex).contains("CDATA[") || this.getLines().get(currentLineIndex).contains("/*") || this.getLines().get(currentLineIndex).trim().equals("")) {
            ++currentLineIndex;
        }
        return currentLineIndex - startingLineIndex;
    }

    private void copyScriptLinesKeepingOriginalLineIndices() {
        List<String> scriptLines = this.extractScriptLines();
        List<String> metaDataLines = this.extractMetaDataLines();
        String packageLine = "package " + this.getPackageName() + "{";
        String classLine = "class " + this.getClassName().split("\\.")[0] + "{";
        scriptLines.set(0, packageLine);
        if (metaDataLines.isEmpty()) {
            scriptLines.set(1, classLine);
        } else {
            int firstMetaDataLine;
            for (int i = firstMetaDataLine = this.getFirstMetaDataLine(this.getLines()); i < firstMetaDataLine + metaDataLines.size(); ++i) {
                scriptLines.set(i, metaDataLines.get(i - firstMetaDataLine));
            }
            scriptLines.set(firstMetaDataLine + metaDataLines.size(), classLine);
        }
        scriptLines.set(scriptLines.size() - 1, "}}");
        this.scriptBlock = scriptLines.toArray(new String[scriptLines.size()]);
    }

    private List<String> extractMetaDataLines() {
        ArrayList<String> metaDataLines = new ArrayList<String>();
        int currentLineIndex = 0;
        int start = 0;
        int end = 0;
        for (String line : this.getLines()) {
            if (line.contains(METADATA_TAG)) {
                if (line.contains("</")) {
                    end = currentLineIndex;
                    break;
                }
                if (line.contains("<")) {
                    start = currentLineIndex + 1;
                }
            }
            ++currentLineIndex;
        }
        metaDataLines.addAll(this.getLines().subList(start, end));
        return metaDataLines;
    }

    private void extractScriptBlock() {
        int currentLineIndex = 0;
        this.startLine = 0;
        this.endLine = 0;
        for (String line : this.getLines()) {
            if (line.contains("Script>")) {
                if (line.contains("</")) {
                    this.endLine = currentLineIndex - 1;
                    break;
                }
                if (line.contains("<")) {
                    this.startLine = currentLineIndex + this.computeScriptOffSet(currentLineIndex);
                }
            }
            ++currentLineIndex;
        }
        this.copyScriptLinesKeepingOriginalLineIndices();
    }

    private List<String> extractScriptLines() {
        int j;
        ArrayList<String> scriptLines = new ArrayList<String>();
        for (j = 0; j < this.startLine; ++j) {
            scriptLines.add("");
        }
        if (this.startLine < this.endLine) {
            this.actualScriptBlock = this.getLines().subList(this.startLine, this.endLine).toArray(new String[this.endLine - this.startLine]);
            scriptLines.addAll(new ArrayList<String>(this.getLines().subList(this.startLine, this.endLine)));
        }
        for (j = this.endLine; j < this.getLines().size(); ++j) {
            scriptLines.add("");
        }
        return scriptLines;
    }

    private int getFirstMetaDataLine(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.contains(METADATA_TAG) || !line.contains("<")) continue;
            return i;
        }
        return 0;
    }
}

