/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.rules.core.IFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import java.util.Formatter;
import org.apache.commons.lang.StringUtils;

public final class Violation
implements IFlexViolation {
    public static final String RULESET_CREATOR_URL = "http://opensource.adobe.com/svn/opensource/flexpmd/bin/flex-pmd-ruleset-creator.html?rule=";
    private final int beginColumn;
    private final int beginLine;
    private int endColumn;
    private final int endLine;
    private final IFlexFile file;
    private final IFlexRule rule;
    private String ruleMessage = "";

    public Violation(ViolationPosition position, IFlexRule violatedRule, IFlexFile violatedFile) {
        this.beginLine = position.getBeginLine();
        this.endLine = position.getEndLine();
        this.beginColumn = position.getBeginColumn();
        this.endColumn = position.getEndColumn();
        this.rule = violatedRule;
        this.file = violatedFile;
        if (violatedRule != null) {
            this.ruleMessage = violatedRule.getMessage() == null ? "" : violatedRule.getMessage();
        }
    }

    public void appendToMessage(String messageToAppend) {
        this.ruleMessage = this.ruleMessage + messageToAppend;
    }

    public int compareTo(IFlexViolation otherViolation) {
        int priorityOrder = this.getPrioriyOrder(otherViolation);
        int res = priorityOrder == 0 ? this.getLinePriority(otherViolation) : priorityOrder;
        return res;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public String getClassName() {
        return "";
    }

    public String getDescription() {
        return this.ruleMessage;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getFilename() {
        return this.file.getFullyQualifiedName();
    }

    public String getMethodName() {
        return "";
    }

    public String getPackageName() {
        return this.file.getPackageName();
    }

    public IFlexRule getRule() {
        return this.rule;
    }

    public String getRuleMessage() {
        return this.ruleMessage.endsWith(".") ? this.ruleMessage.substring(0, this.ruleMessage.length() - 1) : this.ruleMessage;
    }

    public String getVariableName() {
        return "";
    }

    public boolean isSuppressed() {
        return false;
    }

    public void replacePlaceholderInMessage(String replacement, int index) {
        this.ruleMessage = this.ruleMessage.replace("{" + index + "}", replacement);
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    public String toXmlString(IFlexFile violatedFile, String ruleSetName) {
        Formatter formatter = new Formatter();
        if (this.rule != null) {
            StringBuffer message = new StringBuffer(this.getRuleMessage());
            formatter.format("      <violation beginline=\"%d\" endline=\"%d\" begincolumn=\"%d\" endcolumn=\"%d\" rule=\"%s\" ruleset=\"%s\" package=\"%s\" class=\"%s\" externalInfoUrl=\"%s\" priority=\"%s\">%s</violation>" + this.getNewLine(), this.beginLine, this.endLine, this.beginColumn, this.endColumn, this.rule.getRuleName(), ruleSetName, violatedFile.getPackageName(), violatedFile.getClassName(), RULESET_CREATOR_URL + this.extractShortName(this.rule.getName()), this.rule.getPriority(), message);
        }
        return formatter.toString();
    }

    String getNewLine() {
        return System.getProperty("line.separator");
    }

    private String extractShortName(String name) {
        return StringUtils.substringAfterLast((String)name, (String)".");
    }

    private int getLinePriority(IFlexViolation otherViolation) {
        int res = this.beginLine > otherViolation.getBeginLine() ? 1 : (this.beginLine < otherViolation.getBeginLine() ? -1 : 0);
        return res;
    }

    private int getPrioriyOrder(IFlexViolation otherViolation) {
        int res = this.rule.getPriority() > otherViolation.getRule().getPriority() ? 1 : (this.rule.getPriority() < otherViolation.getRule().getPriority() ? -1 : 0);
        return res;
    }
}

