/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.utils.StackTraceUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXpathRelatedRule
extends AbstractFlexRule {
    protected static final Logger LOGGER = Logger.getLogger(AbstractXpathRelatedRule.class.getName());

    private static Map<String, String> toMap(String ... mappingPairs) {
        LinkedHashMap<String, String> prefixMappings = new LinkedHashMap<String, String>(mappingPairs.length / 2);
        for (int i = 0; i < mappingPairs.length; ++i) {
            prefixMappings.put(mappingPairs[i], mappingPairs[++i]);
        }
        return prefixMappings;
    }

    protected abstract Object evaluate(Document var1, XPath var2) throws XPathExpressionException;

    @Override
    protected List<IFlexViolation> findViolationsInCurrentFile() {
        ArrayList<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        try {
            Document doc = this.buildDocument();
            XPath xPath = this.buildXPath();
            this.onEvaluated(violations, doc, xPath);
        }
        catch (XPathExpressionException e) {
            LOGGER.warning(StackTraceUtils.print((String)this.getCurrentFile().getFilename(), (Exception)e));
        }
        catch (FileNotFoundException e) {
            LOGGER.warning(StackTraceUtils.print((String)this.getCurrentFile().getFilename(), (Exception)e));
        }
        catch (ParserConfigurationException e) {
            LOGGER.warning(StackTraceUtils.print((String)this.getCurrentFile().getFilename(), (Exception)e));
        }
        catch (SAXException e) {
            LOGGER.warning(StackTraceUtils.print((String)this.getCurrentFile().getFilename(), (Exception)e));
        }
        catch (IOException e) {
            LOGGER.warning(StackTraceUtils.print((String)this.getCurrentFile().getFilename(), (Exception)e));
        }
        return violations;
    }

    protected abstract String getXPathExpression();

    @Override
    protected boolean isConcernedByTheCurrentFile() {
        return this.getCurrentFile().isMxml();
    }

    protected abstract void onEvaluated(List<IFlexViolation> var1, Document var2, XPath var3) throws XPathExpressionException;

    private Document buildDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(this.getCurrentFile().getFilePath());
    }

    private XPath buildXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContextMap("mx", "http://www.adobe.com/2006/mxml"));
        return xPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NamespaceContextMap
    implements NamespaceContext {
        private final Map<String, String> prefixMap;

        public NamespaceContextMap(Map<String, String> prefixMappings) {
            this.prefixMap = this.createPrefixMap(prefixMappings);
        }

        public NamespaceContextMap(String ... mappingPairs) {
            this(AbstractXpathRelatedRule.toMap(mappingPairs));
        }

        @Override
        public String getNamespaceURI(String prefix) {
            this.prefixMap.get(prefix);
            return this.prefixMap.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }

        private void addConstant(Map<String, String> map, String prefix, String nsURI) {
            map.put(prefix, nsURI);
        }

        private Map<String, String> createPrefixMap(Map<String, String> prefixMappings) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(prefixMappings);
            this.addConstant(map, "xml", "http://www.w3.org/XML/1998/namespace");
            this.addConstant(map, "xmlns", "http://www.w3.org/2000/xmlns/");
            return Collections.unmodifiableMap(map);
        }
    }
}

