/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegexpBasedRule
extends AbstractFlexRule {
    private Pattern pattern;

    public AbstractRegexpBasedRule() {
        this.compilePattern();
    }

    public final void compilePattern() {
        this.pattern = Pattern.compile(this.getRegexp());
    }

    @Override
    public final List<IFlexViolation> findViolationsInCurrentFile() {
        ArrayList<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        if ("".compareTo(this.getRegexp()) != 0) {
            for (int i = 1; i <= this.getCurrentFile().getLinesNb(); ++i) {
                String line = this.getCurrentFile().getLineAt(i);
                if (!this.isCurrentLineConcerned(line) || !this.doesCurrentLineMacthes(line) || !this.isViolationDetectedOnThisMatchingLine(line) || line.contains("/*") || line.contains("//")) continue;
                this.addViolation(violations, ViolationPosition.create(i, i, 0, line.length()));
            }
        }
        return violations;
    }

    final boolean doesCurrentLineMacthes(String line) {
        return this.getMatcher(line).matches();
    }

    protected final Matcher getMatcher(String line) {
        Matcher matcher = this.pattern.matcher(line);
        return matcher;
    }

    protected abstract String getRegexp();

    protected boolean isCurrentLineConcerned(String line) {
        return true;
    }

    protected abstract boolean isViolationDetectedOnThisMatchingLine(String var1);
}

