/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.pmd.rules.core.AbstractFlexRuleTest;
import com.adobe.ac.pmd.rules.core.AbstractRegexpBasedRule;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRegExpBasedRuleTest
extends AbstractFlexRuleTest {
    @Test
    public void testDoesCurrentLineMacthCorrectLine() {
        AbstractRegexpBasedRule rule = this.getRegexpBasedRule();
        if (this.getMatchableLines().length == 0) {
            junit.framework.Assert.fail((String)"the getMatchableLines() is empty");
        }
        for (int i = 0; i < this.getMatchableLines().length; ++i) {
            String correctLine = this.getMatchableLines()[i];
            Assert.assertTrue((String)("This line (\"" + correctLine + "\") should be matched"), (boolean)rule.doesCurrentLineMacthes(correctLine));
        }
    }

    @Test
    public void testDoesCurrentLineMacthIncorrectLine() {
        AbstractRegexpBasedRule rule = this.getRegexpBasedRule();
        if (this.getUnmatchableLines().length == 0) {
            junit.framework.Assert.fail((String)"the getUnmatchableLines() is empty");
        }
        for (int i = 0; i < this.getUnmatchableLines().length; ++i) {
            String incorrectLine = this.getUnmatchableLines()[i];
            Assert.assertFalse((String)("This line  (\"" + incorrectLine + "\") should not be matched"), (boolean)rule.doesCurrentLineMacthes(incorrectLine));
        }
    }

    protected abstract String[] getMatchableLines();

    protected abstract AbstractRegexpBasedRule getRegexpBasedRule();

    protected AbstractFlexRule getRule() {
        return this.getRegexpBasedRule();
    }

    protected abstract String[] getUnmatchableLines();
}

