/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.FlexPmdTestBase;
import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.parser.exceptions.TokenException;
import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlexRuleTest
extends FlexPmdTestBase {
    protected static StringBuffer buildFailuresMessage(List<AssertPosition> failures) {
        StringBuffer message = new StringBuffer(42);
        for (AssertPosition assertPosition : failures) {
            message.append(assertPosition.message + ": expected <" + assertPosition.expectedLine + "> but actually <" + assertPosition.actualLine + ">\n");
        }
        return message;
    }

    protected static List<AssertPosition> buildFailureViolations(String resourcePath, ViolationPosition[] expectedPositions, List<IFlexViolation> violations) {
        ArrayList<AssertPosition> failures = new ArrayList<AssertPosition>();
        for (int i = 0; i < expectedPositions.length; ++i) {
            IFlexViolation violation = violations.get(i);
            ViolationPosition expectedPosition = expectedPositions[i];
            if (expectedPosition.getBeginLine() != violation.getBeginLine()) {
                failures.add(AssertPosition.create("Begining line is not correct at " + i + "th violation on " + resourcePath, expectedPosition.getBeginLine(), violation.getBeginLine()));
            }
            if (expectedPosition.getEndLine() == violation.getEndLine()) continue;
            failures.add(AssertPosition.create("Ending line is not correct at " + i + "th violation on " + resourcePath, expectedPosition.getEndLine(), violation.getEndLine()));
        }
        return failures;
    }

    protected static StringBuffer buildMessageName(Map<String, List<IFlexViolation>> violatedFiles) {
        StringBuffer buffer = new StringBuffer(100);
        for (String violatedFileName : violatedFiles.keySet()) {
            List<IFlexViolation> violations = violatedFiles.get(violatedFileName);
            buffer.append(violatedFileName + " should not contain any violations " + " (" + violations.size() + " found");
            if (violations.size() == 1) {
                buffer.append(" at " + violations.get(0).getBeginLine() + ":" + violations.get(0).getEndLine());
            }
            buffer.append(")\n");
        }
        return buffer;
    }

    @Test
    public final void testProcessNonViolatingFiles() throws IOException, TokenException {
        Map<String, List<IFlexViolation>> violatedFiles = this.extractActualViolatedFiles();
        StringBuffer buffer = AbstractFlexRuleTest.buildMessageName(violatedFiles);
        if (!violatedFiles.isEmpty()) {
            Assert.fail((String)buffer.toString());
        }
    }

    @Test
    public final void testProcessViolatingFiles() {
        Map<String, ViolationPosition[]> expectedPositions = this.computeExpectedViolations(this.getExpectedViolatingFiles());
        for (String fileName : expectedPositions.keySet()) {
            this.assertViolations(fileName, expectedPositions.get(fileName));
        }
    }

    protected abstract ExpectedViolation[] getExpectedViolatingFiles();

    protected List<String> getIgnoreFiles() {
        return new ArrayList<String>();
    }

    protected abstract AbstractFlexRule getRule();

    protected List<IFlexViolation> processFile(String resourcePath) throws IOException, TokenException {
        if (!this.getIgnoreFiles().contains(resourcePath)) {
            return this.getRule().processFile((IFlexFile)this.getTestFiles().get(resourcePath), null, this.getTestFiles());
        }
        return new ArrayList<IFlexViolation>();
    }

    private void assertViolations(String resourcePath, ViolationPosition[] expectedPositions) {
        try {
            List<IFlexViolation> violations = this.processFile(resourcePath);
            Assert.assertEquals((String)("Violations number is not correct for " + resourcePath), (long)expectedPositions.length, (long)violations.size());
            if (expectedPositions.length != 0) {
                this.printFailures(AbstractFlexRuleTest.buildFailureViolations(resourcePath, expectedPositions, violations));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TokenException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private Map<String, ViolationPosition[]> computeExpectedViolations(ExpectedViolation[] expectedViolatingFiles) {
        LinkedHashMap<String, ViolationPosition[]> expectedViolations = new LinkedHashMap<String, ViolationPosition[]>();
        for (ExpectedViolation expectedViolatingFile : expectedViolatingFiles) {
            expectedViolations.put(expectedViolatingFile.file, expectedViolatingFile.positions);
        }
        return expectedViolations;
    }

    private Map<String, List<IFlexViolation>> extractActualViolatedFiles() throws IOException, TokenException {
        LinkedHashMap<String, List<IFlexViolation>> violatedFiles = new LinkedHashMap<String, List<IFlexViolation>>();
        Map<String, ViolationPosition[]> expectedPositions = this.computeExpectedViolations(this.getExpectedViolatingFiles());
        for (Map.Entry fileNameEntry : this.getTestFiles().entrySet()) {
            List<IFlexViolation> violations;
            if (expectedPositions.containsKey(fileNameEntry.getKey()) || (violations = this.processFile((String)fileNameEntry.getKey())).isEmpty()) continue;
            violatedFiles.put((String)fileNameEntry.getKey(), violations);
        }
        return violatedFiles;
    }

    private void printFailures(List<AssertPosition> failures) {
        if (!failures.isEmpty()) {
            Assert.fail((String)AbstractFlexRuleTest.buildFailuresMessage(failures).toString());
        }
    }

    protected static final class ExpectedViolation {
        protected String file;
        protected ViolationPosition[] positions;

        public ExpectedViolation(String fileToBeSet, ViolationPosition[] positionsToBeSet) {
            this.file = fileToBeSet;
            this.positions = positionsToBeSet;
        }
    }

    static final class AssertPosition {
        public int actualLine;
        public int expectedLine;
        public String message;

        public static AssertPosition create(String message, int expectedLine, int actualLine) {
            return new AssertPosition(message, expectedLine, actualLine);
        }

        private AssertPosition(String messageToBeSet, int expectedLineToBeSet, int actualLineToBeSet) {
            this.message = messageToBeSet;
            this.expectedLine = expectedLineToBeSet;
            this.actualLine = actualLineToBeSet;
        }
    }
}

