/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.rules.core.IFlexRule;
import com.adobe.ac.pmd.rules.core.Violation;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import com.adobe.ac.pmd.rules.core.ViolationPriority;
import com.adobe.ac.pmd.rules.core.thresholded.IThresholdedRule;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.pmd.CommonAbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.rules.regex.RegexHelper;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlexRule
extends CommonAbstractRule
implements IFlexRule {
    protected static final String MAXIMUM = "maximum";
    protected static final String MINIMUM = "minimum";
    private static final String AS3_COMMENT_TOKEN = "//";
    private static final Logger LOGGER = Logger.getLogger(AbstractFlexRule.class.getName());
    private static final String MXML_COMMENT_TOKEN = "<!--";
    private IFlexFile currentFile;
    private IPackage currentPackageNode;
    private Set<String> excludes;
    private Map<String, IFlexFile> filesInSourcePath;

    public AbstractFlexRule() {
        this.setDefaultPriority();
    }

    public final void apply(List<?> astCompilationUnits, RuleContext ctx) {
    }

    @Override
    public final String getRuleName() {
        String qualifiedClassName = this.getClass().getName();
        String className = StringUtils.substringAfter((String)qualifiedClassName, (String)".");
        return className.replace("Rule", "");
    }

    @Override
    public final List<IFlexViolation> processFile(IFlexFile file, IPackage packageNode, Map<String, IFlexFile> files) {
        List<IFlexViolation> violations = new ArrayList<IFlexViolation>();
        this.currentFile = file;
        this.filesInSourcePath = files;
        this.currentPackageNode = packageNode;
        if (this.isConcernedByTheCurrentFile() && !this.isFileExcluded(file)) {
            this.onRuleStart();
            violations = this.findViolationsInCurrentFile();
        }
        return violations;
    }

    @Override
    public void setExcludes(Set<String> excludesToBeSet) {
        this.excludes = excludesToBeSet;
    }

    boolean isViolationIgnored(String violatedLine) {
        boolean containsNoPmd;
        boolean bl = containsNoPmd = this.lineContainsNoPmd(violatedLine, MXML_COMMENT_TOKEN) || this.lineContainsNoPmd(violatedLine, AS3_COMMENT_TOKEN);
        if (!containsNoPmd) {
            return false;
        }
        String name = this.getRuleName().replaceAll("Rule", "");
        String ruleName = name.contains(".") ? StringUtils.substringAfterLast((String)name, (String)".") : name;
        String strippedLine = this.computeStrippedLine(violatedLine);
        return this.strippedLineContainsNoPmdAndRuleName(MXML_COMMENT_TOKEN, ruleName, strippedLine) || this.strippedLineContainsNoPmdAndRuleName(AS3_COMMENT_TOKEN, ruleName, strippedLine);
    }

    protected final IFlexViolation addViolation(List<IFlexViolation> violations, ViolationPosition position) {
        Violation violation = new Violation(position, this, this.getCurrentFile());
        int beginLine = position.getBeginLine();
        this.prettyPrintMessage(violation);
        if (beginLine == -1 || beginLine == 0) {
            violations.add(violation);
        } else if (beginLine <= this.getCurrentFile().getLinesNb()) {
            if (this.isViolationIgnored(this.getCurrentFile().getLineAt(beginLine))) {
                LOGGER.info(this.getRuleName() + " has been ignored in " + this.getCurrentFile().getFilename() + " (" + beginLine + ")");
            } else {
                violations.add(violation);
            }
        }
        return violation;
    }

    protected final IFlexViolation addViolation(List<IFlexViolation> violations, ViolationPosition position, String ... messageToReplace) {
        IFlexViolation violation = this.addViolation(violations, position);
        for (int i = 0; i < messageToReplace.length; ++i) {
            violation.replacePlaceholderInMessage(messageToReplace[i], i);
        }
        return violation;
    }

    protected abstract List<IFlexViolation> findViolationsInCurrentFile();

    protected IFlexFile getCurrentFile() {
        return this.currentFile;
    }

    protected final IPackage getCurrentPackageNode() {
        return this.currentPackageNode;
    }

    protected abstract ViolationPriority getDefaultPriority();

    protected final Map<String, IFlexFile> getFilesInSourcePath() {
        return this.filesInSourcePath;
    }

    protected final Map<String, PropertyDescriptor> getThresholdedRuleProperties(IThresholdedRule rule) {
        LinkedHashMap<String, PropertyDescriptor> properties = new LinkedHashMap<String, PropertyDescriptor>();
        properties.put(rule.getThresholdName(), (PropertyDescriptor)new IntegerProperty(rule.getThresholdName(), "", rule.getDefaultThreshold(), (float)properties.size()));
        return properties;
    }

    protected abstract boolean isConcernedByTheCurrentFile();

    protected void onRuleStart() {
    }

    private String computeStrippedLine(String violatedLine) {
        String comment_token = this.getCurrentFile().isMxml() ? MXML_COMMENT_TOKEN : AS3_COMMENT_TOKEN;
        String strippedLine = violatedLine;
        if (violatedLine.indexOf(comment_token + " N") > 0) {
            strippedLine = StringUtils.strip((String)violatedLine.substring(violatedLine.indexOf(comment_token + " N")));
        } else if (violatedLine.indexOf(comment_token + "N") > 0) {
            strippedLine = StringUtils.strip((String)violatedLine.substring(violatedLine.indexOf(comment_token + "N")));
        }
        return strippedLine;
    }

    private boolean isFileExcluded(IFlexFile file) {
        if (this.excludes != null) {
            for (String exclusion : this.excludes) {
                Pattern pattern = Pattern.compile(exclusion);
                if (!RegexHelper.isMatch((Pattern)pattern, (String)file.getFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean lineContainsNoPmd(String violatedLine, String comment_token) {
        return violatedLine.contains(comment_token + " No PMD") || violatedLine.contains(comment_token + " NO PMD") || violatedLine.contains(comment_token + " NOPMD") || violatedLine.contains(comment_token + "NOPMD");
    }

    private void prettyPrintMessage(IFlexViolation violation) {
        int nbOfBraces = violation.getRuleMessage().split("\\{").length - 1;
        if (this instanceof IThresholdedRule) {
            IThresholdedRule thresholdeRule = (IThresholdedRule)((Object)this);
            violation.replacePlaceholderInMessage(String.valueOf(thresholdeRule.getThreshold()), nbOfBraces - 2);
            violation.replacePlaceholderInMessage(String.valueOf(thresholdeRule.getActualValueForTheCurrentViolation()), nbOfBraces - 1);
        }
        if (this.getDescription() != null) {
            violation.appendToMessage(". ");
            violation.appendToMessage(this.getDescription());
        }
    }

    private void setDefaultPriority() {
        this.setPriority(Integer.valueOf(this.getDefaultPriority().toString()));
    }

    private boolean strippedLineContainsNoPmdAndRuleName(String comment_token, String ruleName, String strippedLine) {
        return strippedLine.endsWith(comment_token + " No PMD") || strippedLine.endsWith(comment_token + " NO PMD") || strippedLine.endsWith(comment_token + " NOPMD") || strippedLine.endsWith(comment_token + "NOPMD") || strippedLine.contains(ruleName);
    }
}

