/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.rules.core;

import com.adobe.ac.pmd.IFlexViolation;
import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import com.adobe.ac.pmd.rules.core.AbstractFlexRule;
import com.adobe.ac.pmd.rules.core.IFlexAstRule;
import com.adobe.ac.pmd.rules.core.ViolationPosition;
import com.adobe.ac.utils.StackTraceUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAstFlexRule
extends AbstractFlexRule
implements IFlexAstRule {
    private static final Logger LOGGER = Logger.getLogger(AbstractAstFlexRule.class.getName());
    private final List<IFlexViolation> violations = new ArrayList<IFlexViolation>();

    protected static IParserNode getNameFromFunctionDeclaration(IParserNode functionNode) {
        IParserNode nameChild = null;
        for (IParserNode child : functionNode.getChildren()) {
            if (!child.is(NodeKind.NAME)) continue;
            nameChild = child;
            break;
        }
        return nameChild;
    }

    protected static IParserNode getTypeFromFieldDeclaration(IParserNode fieldNode) {
        return fieldNode.getChild(0).getChild(1);
    }

    @Override
    public boolean isConcernedByTheCurrentFile() {
        return true;
    }

    protected final IFlexViolation addViolation(IFunction function) {
        IParserNode name = AbstractAstFlexRule.getNameFromFunctionDeclaration(function.getInternalNode());
        return this.addViolation(name, name, name.getStringValue());
    }

    protected final IFlexViolation addViolation(IFunction function, String messageToReplace) {
        IParserNode name = AbstractAstFlexRule.getNameFromFunctionDeclaration(function.getInternalNode());
        return this.addViolation(name, name, messageToReplace);
    }

    protected final IFlexViolation addViolation(INode violatingNode) {
        return this.addViolation(violatingNode.getInternalNode(), violatingNode.getInternalNode(), new String[0]);
    }

    protected final IFlexViolation addViolation(INode violatingNode, String ... messageToReplace) {
        return this.addViolation(violatingNode.getInternalNode(), violatingNode.getInternalNode(), messageToReplace);
    }

    protected final IFlexViolation addViolation(IParserNode violatingNode) {
        return this.addViolation(violatingNode, violatingNode, new String[0]);
    }

    protected final IFlexViolation addViolation(IParserNode beginningNode, IParserNode endNode, String ... messageToReplace) {
        if (this.isAlreadyViolationAdded(beginningNode)) {
            return null;
        }
        IFlexViolation violation = this.addViolation(ViolationPosition.create(beginningNode.getLine(), endNode.getLine(), beginningNode.getColumn(), endNode.getColumn()));
        for (int i = 0; i < messageToReplace.length; ++i) {
            violation.replacePlaceholderInMessage(messageToReplace[i], i);
        }
        return violation;
    }

    protected final IFlexViolation addViolation(IParserNode violatingNode, String ... messageToReplace) {
        return this.addViolation(violatingNode, violatingNode, messageToReplace);
    }

    protected final IFlexViolation addViolation(ViolationPosition violationPosition) {
        return this.addViolation(this.violations, violationPosition);
    }

    protected void findViolations(IClass classNode) {
        this.findViolationsFromAttributes(classNode.getAttributes());
        this.findViolationsFromConstants(classNode.getConstants());
        this.findViolations(classNode.getFunctions());
        if (classNode.getConstructor() != null) {
            this.findViolationsFromConstructor(classNode.getConstructor());
        }
    }

    protected void findViolations(IFunction function) {
    }

    protected void findViolations(IPackage packageNode) {
        IClass classNode = packageNode.getClassNode();
        if (classNode != null) {
            this.findViolations(classNode);
        }
    }

    protected void findViolations(List<IFunction> functions) {
        for (IFunction function : functions) {
            this.findViolations(function);
        }
    }

    protected void findViolationsFromAttributes(List<IAttribute> variables) {
    }

    protected void findViolationsFromConstants(List<IConstant> constants) {
    }

    protected void findViolationsFromConstructor(IFunction constructor) {
    }

    @Override
    protected final List<IFlexViolation> findViolationsInCurrentFile() {
        try {
            if (this.getCurrentPackageNode() != null) {
                this.visitCompilationUnit(this.getCurrentPackageNode().getInternalNode());
                this.findViolations(this.getCurrentPackageNode());
            }
        }
        catch (Exception e) {
            LOGGER.warning("on " + this.getCurrentFile().getFilePath());
            LOGGER.warning(StackTraceUtils.print((Exception)e));
        }
        ArrayList<IFlexViolation> copy = new ArrayList<IFlexViolation>(this.violations);
        this.violations.clear();
        return copy;
    }

    protected void visitCatch(IParserNode catchNode) {
        this.visitNameTypeInit(catchNode.getChild(0));
        this.visitBlock(catchNode.getChild(1));
    }

    protected void visitClass(IParserNode classNode) {
        IParserNode content = null;
        for (IParserNode node : classNode.getChildren()) {
            if (!node.is(NodeKind.CONTENT)) continue;
            content = node;
            break;
        }
        this.visitClassContent(content);
    }

    protected void visitCondition(IParserNode condition) {
        this.visitExpression(condition);
    }

    protected void visitDo(IParserNode doNode) {
        this.visitBlock(doNode.getChild(0));
        this.visitCondition(doNode.getChild(1));
    }

    protected void visitElse(IParserNode ifNode) {
        this.visitBlock(ifNode.getChild(2));
    }

    protected void visitEmptyStatetement(IParserNode statementNode) {
    }

    protected void visitFinally(IParserNode finallyNode) {
        if (this.isNodeNavigable(finallyNode)) {
            this.visitBlock(finallyNode.getChild(0));
        }
    }

    protected void visitFor(IParserNode forNode) {
        this.visitBlock(forNode.getChild(3));
    }

    protected void visitForEach(IParserNode foreachNode) {
        this.visitBlock(foreachNode.getChild(2));
    }

    protected void visitFunction(IParserNode functionNode, FunctionType type) {
        Iterator iterator = functionNode.getChildren().iterator();
        IParserNode currentNode = (IParserNode)iterator.next();
        while (currentNode.is(NodeKind.META_LIST) || currentNode.is(NodeKind.MOD_LIST) || currentNode.is(NodeKind.AS_DOC) || currentNode.is(NodeKind.MULTI_LINE_COMMENT)) {
            currentNode = (IParserNode)iterator.next();
        }
        currentNode = (IParserNode)iterator.next();
        this.visitParameters(currentNode);
        currentNode = (IParserNode)iterator.next();
        this.visitFunctionReturnType(currentNode);
        currentNode = (IParserNode)iterator.next();
        this.visitFunctionBody(currentNode);
    }

    protected void visitFunctionReturnType(IParserNode functionReturnTypeNode) {
        this.visitBlock(functionReturnTypeNode);
    }

    protected void visitIf(IParserNode ifNode) {
        this.visitCondition(ifNode.getChild(0));
        this.visitThen(ifNode);
        if (ifNode.numChildren() == 3) {
            this.visitElse(ifNode);
        }
    }

    protected void visitInterface(IParserNode interfaceNode) {
    }

    protected void visitMethodCall(IParserNode methodCallNode) {
        Iterator iterator = methodCallNode.getChildren().iterator();
        this.visitExpression((IParserNode)iterator.next());
        do {
            this.visitExpressionList((IParserNode)iterator.next());
        } while (iterator.hasNext());
    }

    protected void visitNewExpression(IParserNode newExpression) {
        this.visitExpression(newExpression.getChild(0));
        this.visitExpressionList(newExpression.getChild(1));
    }

    protected void visitOperator(IParserNode statementNode) {
    }

    protected void visitParameters(IParserNode functionParametersNode) {
        if (this.isNodeNavigable(functionParametersNode)) {
            for (IParserNode node2 : functionParametersNode.getChildren()) {
                this.visitNameTypeInit(node2.getChild(0));
            }
        }
    }

    protected void visitReturn(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            this.visitExpression(ast.getChild(0));
        }
    }

    protected void visitStatement(IParserNode statementNode) {
        switch (statementNode.getId()) {
            case OP: {
                this.visitOperator(statementNode);
                break;
            }
            case RETURN: {
                this.visitReturn(statementNode);
                break;
            }
            case IF: {
                this.visitIf(statementNode);
                break;
            }
            case FOR: {
                this.visitFor(statementNode);
                break;
            }
            case FOREACH: {
                this.visitForEach(statementNode);
                break;
            }
            case DO: {
                this.visitDo(statementNode);
                break;
            }
            case WHILE: {
                this.visitWhile(statementNode);
                break;
            }
            case SWITCH: {
                this.visitSwitch(statementNode);
                break;
            }
            case TRY: {
                this.visitTry(statementNode);
                break;
            }
            case CATCH: {
                this.visitCatch(statementNode);
                break;
            }
            case FINALLY: {
                this.visitFinally(statementNode);
                break;
            }
            case STMT_EMPTY: {
                this.visitEmptyStatetement(statementNode);
                break;
            }
            case LEFT_CURLY_BRACKET: {
                this.visitBlock(statementNode);
                break;
            }
            default: {
                this.visitExpressionList(statementNode);
            }
        }
    }

    protected void visitSwitch(IParserNode switchNode) {
        Iterator iterator = switchNode.getChildren().iterator();
        this.visitExpression((IParserNode)iterator.next());
        IParserNode cases = (IParserNode)iterator.next();
        for (IParserNode caseNode : cases.getChildren()) {
            IParserNode child = caseNode.getChild(0);
            if (child.is(NodeKind.DEFAULT)) {
                this.visitSwitchDefaultCase(caseNode.getChild(1));
                continue;
            }
            this.visitSwitchCase(caseNode.getChild(1));
            this.visitExpression(child);
        }
    }

    protected void visitSwitchCase(IParserNode switchCaseNode) {
        this.visitBlock(switchCaseNode);
    }

    protected void visitSwitchDefaultCase(IParserNode defaultCaseNode) {
        this.visitBlock(defaultCaseNode);
    }

    protected void visitThen(IParserNode ifNode) {
        this.visitBlock(ifNode.getChild(1));
    }

    protected void visitTry(IParserNode ast) {
        this.visitBlock(ast.getChild(0));
    }

    protected void visitVariableInitialization(IParserNode node) {
        this.visitExpression(node);
    }

    protected void visitVarOrConstList(IParserNode variableNode, VariableOrConstant varOrConst, VariableScope scope) {
        Iterator iterator = variableNode.getChildren().iterator();
        IParserNode node = (IParserNode)iterator.next();
        while (node.is(NodeKind.META_LIST) || node.is(NodeKind.MOD_LIST)) {
            node = (IParserNode)iterator.next();
        }
        while (node != null) {
            this.visitNameTypeInit(node);
            node = iterator.hasNext() ? (IParserNode)iterator.next() : null;
        }
    }

    protected void visitWhile(IParserNode whileNode) {
        this.visitCondition(whileNode.getChild(0));
        this.visitBlock(whileNode.getChild(1));
    }

    private boolean isAlreadyViolationAdded(IParserNode nodeToBeAdded) {
        for (IFlexViolation violation : this.violations) {
            if (violation.getBeginLine() != nodeToBeAdded.getLine() || violation.getBeginColumn() != nodeToBeAdded.getColumn()) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeNavigable(IParserNode node) {
        return node != null && node.numChildren() != 0;
    }

    private void visitAdditiveExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.ADD, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitMultiplicativeExpression(ast);
            }
        });
    }

    private void visitAndExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.AND, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitBitwiseOrExpression(ast);
            }
        });
    }

    private void visitArrayAccessor(IParserNode ast) {
        Iterator iterator = ast.getChildren().iterator();
        this.visitExpression((IParserNode)iterator.next());
        do {
            this.visitExpression((IParserNode)iterator.next());
        } while (iterator.hasNext());
    }

    private void visitBitwiseAndExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.B_AND, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitEqualityExpression(ast);
            }
        });
    }

    private void visitBitwiseOrExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.B_OR, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitBitwiseXorExpression(ast);
            }
        });
    }

    private void visitBitwiseXorExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.B_XOR, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitBitwiseAndExpression(ast);
            }
        });
    }

    private void visitBlock(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            for (IParserNode node : ast.getChildren()) {
                this.visitStatement(node);
            }
        } else if (ast != null) {
            this.visitStatement(ast);
        }
    }

    private void visitClassContent(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            for (IParserNode node : ast.getChildren()) {
                if (node.is(NodeKind.VAR_LIST)) {
                    this.visitVarOrConstList(node, VariableOrConstant.VARIABLE, VariableScope.IN_CLASS);
                    continue;
                }
                if (!node.is(NodeKind.CONST_LIST)) continue;
                this.visitVarOrConstList(node, VariableOrConstant.CONSTANT, VariableScope.IN_CLASS);
            }
            for (IParserNode node : ast.getChildren()) {
                if (node.is(NodeKind.FUNCTION)) {
                    this.visitFunction(node, FunctionType.NORMAL);
                    continue;
                }
                if (node.is(NodeKind.SET)) {
                    this.visitFunction(node, FunctionType.SETTER);
                    continue;
                }
                if (!node.is(NodeKind.GET)) continue;
                this.visitFunction(node, FunctionType.GETTER);
            }
        }
    }

    private void visitCompilationUnit(IParserNode ast) {
        for (IParserNode node : ast.getChildren()) {
            if (node.is(NodeKind.PACKAGE) && node.numChildren() >= 2) {
                this.visitPackageContent(node.getChild(1));
            }
            if (node.is(NodeKind.PACKAGE) || node.numChildren() <= 0) continue;
            this.visitPackageContent(node);
        }
    }

    private void visitConditionalExpression(IParserNode ast) {
        if (ast != null) {
            if (ast.is(NodeKind.CONDITIONAL)) {
                Iterator iterator = ast.getChildren().iterator();
                IParserNode node = (IParserNode)iterator.next();
                this.visitOrExpression(node);
                while (iterator.hasNext()) {
                    this.visitExpression((IParserNode)iterator.next());
                    this.visitExpression((IParserNode)iterator.next());
                }
            } else {
                this.visitOrExpression(ast);
            }
        }
    }

    private void visitEqualityExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.EQUALITY, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitRelationalExpression(ast);
            }
        });
    }

    private void visitExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.ASSIGN, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitConditionalExpression(ast);
            }
        });
    }

    private void visitExpression(IParserNode ast, NodeKind kind, ExpressionVisitor visitor) {
        if (ast.is(kind)) {
            Iterator iterator = ast.getChildren().iterator();
            IParserNode node = (IParserNode)iterator.next();
            visitor.visitExpression(node);
            while (iterator.hasNext()) {
                iterator.next();
                visitor.visitExpression((IParserNode)iterator.next());
            }
        } else {
            visitor.visitExpression(ast);
        }
    }

    private void visitExpressionList(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            for (IParserNode node : ast.getChildren()) {
                this.visitExpression(node);
            }
        }
    }

    private void visitFunctionBody(IParserNode node) {
        this.visitBlock(node);
    }

    private void visitMultiplicativeExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.MULTIPLICATION, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitUnaryExpression(ast);
            }
        });
    }

    private void visitNameTypeInit(IParserNode ast) {
        if (ast != null && ast.numChildren() != 0) {
            Iterator iterator = ast.getChildren().iterator();
            iterator.next();
            iterator.next();
            if (iterator.hasNext()) {
                IParserNode node = (IParserNode)iterator.next();
                this.visitVariableInitialization(node);
            }
        }
    }

    private void visitObjectInitialization(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            for (IParserNode node : ast.getChildren()) {
                this.visitExpression(node.getChild(1));
            }
        }
    }

    private void visitOrExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.OR, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitAndExpression(ast);
            }
        });
    }

    private void visitPackageContent(IParserNode ast) {
        if (this.isNodeNavigable(ast)) {
            for (IParserNode node : ast.getChildren()) {
                if (node.is(NodeKind.CLASS)) {
                    this.visitClass(node);
                    continue;
                }
                if (!node.is(NodeKind.INTERFACE)) continue;
                this.visitInterface(node);
            }
        }
    }

    private void visitPrimaryExpression(IParserNode ast) {
        if (ast.is(NodeKind.NEW)) {
            this.visitNewExpression(ast);
        } else if (ast.numChildren() != 0 && ast.is(NodeKind.ARRAY)) {
            this.visitExpressionList(ast);
        } else if (ast.is(NodeKind.OBJECT)) {
            this.visitObjectInitialization(ast);
        } else if (ast.is(NodeKind.E4X_ATTR)) {
            IParserNode node = ast.getChild(0);
            if (!node.is(NodeKind.NAME) && !node.is(NodeKind.STAR)) {
                this.visitExpression(node);
            }
        } else {
            this.visitExpressionList(ast);
        }
    }

    private void visitRelationalExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.RELATION, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitShiftExpression(ast);
            }
        });
    }

    private void visitShiftExpression(IParserNode ast) {
        this.visitExpression(ast, NodeKind.SHIFT, new ExpressionVisitor(){

            public void visitExpression(IParserNode ast) {
                AbstractAstFlexRule.this.visitAdditiveExpression(ast);
            }
        });
    }

    private void visitUnaryExpression(IParserNode ast) {
        switch (ast.getId()) {
            case PRE_INC: 
            case PRE_DEC: 
            case MINUS: 
            case PLUS: {
                this.visitUnaryExpression(ast.getChild(0));
                break;
            }
            default: {
                this.visitUnaryExpressionNotPlusMinus(ast);
            }
        }
    }

    private void visitUnaryExpressionNotPlusMinus(IParserNode ast) {
        switch (ast.getId()) {
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case NOT: 
            case B_NOT: {
                this.visitExpression(ast.getChild(0));
                break;
            }
            default: {
                this.visitUnaryPostfixExpression(ast);
            }
        }
    }

    private void visitUnaryPostfixExpression(IParserNode ast) {
        switch (ast.getId()) {
            case ARRAY_ACCESSOR: {
                this.visitArrayAccessor(ast);
                break;
            }
            case DOT: 
            case E4X_FILTER: {
                this.visitExpression(ast.getChild(0));
                this.visitExpression(ast.getChild(1));
                break;
            }
            case POST_INC: 
            case POST_DEC: {
                this.visitPrimaryExpression(ast.getChild(0));
                break;
            }
            case CALL: {
                this.visitMethodCall(ast);
                break;
            }
            case E4X_STAR: {
                this.visitExpression(ast.getChild(0));
                break;
            }
            default: {
                this.visitPrimaryExpression(ast);
            }
        }
    }

    private static interface ExpressionVisitor {
        public void visitExpression(IParserNode var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VariableScope {
        IN_CLASS,
        IN_FUNCTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VariableOrConstant {
        CONSTANT,
        VARIABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FunctionType {
        GETTER,
        NORMAL,
        SETTER;

    }
}

