/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IFieldInitialization;
import com.adobe.ac.pmd.nodes.IIdentifierNode;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.IModifiersHolder;
import com.adobe.ac.pmd.nodes.IVariable;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.nodes.impl.AbstractNode;
import com.adobe.ac.pmd.nodes.impl.FieldInitializationNode;
import com.adobe.ac.pmd.nodes.impl.IdentifierNode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VariableNode
extends AbstractNode
implements IVariable,
IModifiersHolder {
    private IFieldInitialization initializationExpression;
    private final Map<MetaData, List<IMetaData>> metaDataList = new LinkedHashMap<MetaData, List<IMetaData>>();
    private final Set<Modifier> modifiers = new HashSet<Modifier>();
    private IdentifierNode name;
    private IdentifierNode type;

    protected VariableNode(IParserNode rootNode) {
        super(rootNode);
    }

    @Override
    public void add(IMetaData metaData) {
        MetaData metaDataImpl = MetaData.create(metaData.getName());
        if (!this.metaDataList.containsKey((Object)metaDataImpl)) {
            this.metaDataList.put(metaDataImpl, new ArrayList());
        }
        this.metaDataList.get((Object)metaDataImpl).add(metaData);
    }

    @Override
    public void add(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public VariableNode compute() {
        if (this.getInternalNode().is(NodeKind.NAME_TYPE_INIT)) {
            this.computeNameTypeInit(this.getInternalNode());
        } else if (this.getInternalNode().numChildren() != 0) {
            for (IParserNode child : this.getInternalNode().getChildren()) {
                if (child.is(NodeKind.NAME_TYPE_INIT)) {
                    this.computeNameTypeInit(child);
                    continue;
                }
                if (!child.is(NodeKind.META_LIST)) continue;
                VariableNode.computeMetaDataList(this, child);
            }
        }
        return this;
    }

    @Override
    public List<IMetaData> getAllMetaData() {
        ArrayList<IMetaData> list = new ArrayList<IMetaData>();
        for (Map.Entry<MetaData, List<IMetaData>> entry : this.metaDataList.entrySet()) {
            list.addAll((Collection<IMetaData>)entry.getValue());
        }
        return list;
    }

    @Override
    public IFieldInitialization getInitializationExpression() {
        return this.initializationExpression;
    }

    @Override
    public List<IMetaData> getMetaData(MetaData metaDataName) {
        return this.metaDataList.get((Object)metaDataName);
    }

    @Override
    public int getMetaDataCount() {
        return this.metaDataList.size();
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name.toString();
    }

    @Override
    public IIdentifierNode getType() {
        return this.type;
    }

    @Override
    public boolean is(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    private void computeNameTypeInit(IParserNode nameTypeInit) {
        if (nameTypeInit.numChildren() != 0) {
            for (IParserNode child : nameTypeInit.getChildren()) {
                if (child.is(NodeKind.NAME)) {
                    this.name = IdentifierNode.create(child);
                    continue;
                }
                if (child.is(NodeKind.TYPE)) {
                    this.type = IdentifierNode.create(child);
                    continue;
                }
                if (child.is(NodeKind.INIT)) {
                    this.initializationExpression = FieldInitializationNode.create(child);
                    continue;
                }
                LOGGER.warning("unknown node type " + child.toString());
            }
        }
    }
}

