/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.nodes.impl.AbstractNode;
import com.adobe.ac.pmd.nodes.impl.ClassNode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageNode
extends AbstractNode
implements IPackage {
    private IClass classNode = null;
    private final List<IFunction> functions;
    private final List<IParserNode> imports = new ArrayList<IParserNode>();
    private String name;

    protected PackageNode(IParserNode node) {
        super(node);
        this.functions = new ArrayList<IFunction>();
    }

    @Override
    public PackageNode compute() {
        IParserNode classWrapperNode = this.getClassNodeFromCompilationUnitNode(this.getInternalNode(), 3);
        IParserNode firstChild = this.getInternalNode().getChild(0);
        this.name = firstChild.numChildren() > 0 && firstChild.getChild(0).getStringValue() != null ? firstChild.getChild(0).getStringValue() : "";
        if (classWrapperNode != null) {
            this.classNode = new ClassNode(classWrapperNode).compute();
        }
        if (firstChild.numChildren() > 1 && firstChild.getChild(1).numChildren() != 0) {
            List children = firstChild.getChild(1).getChildren();
            for (IParserNode node : children) {
                if (!node.is(NodeKind.IMPORT)) continue;
                this.imports.add(node);
            }
        }
        return this;
    }

    @Override
    public IClass getClassNode() {
        return this.classNode;
    }

    @Override
    public String getFullyQualifiedClassName() {
        if (!"".equals(this.name)) {
            return this.name + "." + this.classNode.getName();
        }
        return this.classNode == null ? "" : this.classNode.getName();
    }

    @Override
    public List<IFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public List<IParserNode> getImports() {
        return this.imports;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private IParserNode getClassNodeFromCompilationUnitNode(IParserNode node, int depth) {
        if (depth == 0 || node.numChildren() == 0) {
            return null;
        }
        for (IParserNode child : node.getChildren()) {
            if (child.is(NodeKind.CLASS) || child.is(NodeKind.INTERFACE)) {
                return child;
            }
            IParserNode localClassNode = this.getClassNodeFromCompilationUnitNode(child, depth - 1);
            if (localClassNode == null) continue;
            return localClassNode;
        }
        return null;
    }
}

