/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.impl.AbstractNode;
import com.adobe.ac.pmd.parser.IParserNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaDataNode
extends AbstractNode
implements IMetaData {
    private List<String> attributeNames;
    private String name;
    private String parameter;
    private Map<String, String[]> parameters;

    protected MetaDataNode(IParserNode node) {
        super(node);
    }

    @Override
    public MetaDataNode compute() {
        String stringValue = this.getInternalNode().getStringValue();
        this.name = stringValue.indexOf(" ( ") > -1 ? stringValue.substring(0, stringValue.indexOf(" ( ")) : stringValue;
        this.parameter = stringValue.indexOf("( ") > -1 ? stringValue.substring(stringValue.indexOf("( ") + 2, stringValue.lastIndexOf(" )")) : "";
        this.computeAttributeNames();
        return this;
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public String getDefaultValue() {
        return this.parameter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getProperty(String property) {
        return this.parameters.containsKey(property) ? this.parameters.get(property) : new String[]{};
    }

    @Override
    public List<String> getPropertyAsList(String property) {
        return Arrays.asList(this.getProperty(property));
    }

    private void computeAttributeNames() {
        String[] pairs;
        this.attributeNames = new ArrayList<String>();
        this.parameters = new LinkedHashMap<String, String[]>();
        for (String pair : pairs = this.getPairs()) {
            String[] pairSplit = pair.split("=");
            if (pairSplit.length != 2) continue;
            this.attributeNames.add(pairSplit[0].trim());
            this.parameters.put(pairSplit[0].trim(), pairSplit[1].trim().replaceAll("'", "").replaceAll("\"", "").split(","));
        }
    }

    private String[] getPairs() {
        return this.parameter.split(",");
    }
}

