/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IConstant;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IMetaData;
import com.adobe.ac.pmd.nodes.MetaData;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.nodes.impl.AbstractNode;
import com.adobe.ac.pmd.nodes.impl.AttributeNode;
import com.adobe.ac.pmd.nodes.impl.ConstantNode;
import com.adobe.ac.pmd.nodes.impl.FunctionNode;
import com.adobe.ac.pmd.nodes.impl.IdentifierNode;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.NodeKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassNode
extends AbstractNode
implements IClass {
    private IParserNode asDoc = null;
    private final List<IAttribute> attributes;
    private IParserNode block;
    private final List<IConstant> constants;
    private IFunction constructor;
    private String extensionName;
    private final List<IFunction> functions;
    private List<IParserNode> implementations;
    private final Map<MetaData, List<IMetaData>> metaDataList;
    private final Set<Modifier> modifiers = new HashSet<Modifier>();
    private final List<IParserNode> multiLinesComments;
    private IdentifierNode name = null;

    protected ClassNode(IParserNode node) {
        super(node);
        this.metaDataList = new LinkedHashMap<MetaData, List<IMetaData>>();
        this.implementations = new ArrayList<IParserNode>();
        this.constants = new ArrayList<IConstant>();
        this.attributes = new ArrayList<IAttribute>();
        this.functions = new ArrayList<IFunction>();
        this.multiLinesComments = new ArrayList<IParserNode>();
    }

    @Override
    public void add(IMetaData metaData) {
        MetaData metaDataImpl = MetaData.create(metaData.getName());
        if (!this.metaDataList.containsKey((Object)metaDataImpl)) {
            this.metaDataList.put(metaDataImpl, new ArrayList());
        }
        this.metaDataList.get((Object)metaDataImpl).add(metaData);
    }

    @Override
    public void add(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public ClassNode compute() {
        if (this.getInternalNode().numChildren() != 0) {
            for (IParserNode node : this.getInternalNode().getChildren()) {
                if (node.is(NodeKind.CONTENT)) {
                    this.computeClassContent(node);
                } else if (node.is(NodeKind.MOD_LIST)) {
                    ClassNode.computeModifierList(this, node);
                } else if (node.is(NodeKind.NAME)) {
                    this.name = IdentifierNode.create(node);
                } else if (node.is(NodeKind.META_LIST)) {
                    ClassNode.computeMetaDataList(this, node);
                } else if (node.is(NodeKind.AS_DOC)) {
                    this.asDoc = node;
                } else if (node.is(NodeKind.MULTI_LINE_COMMENT)) {
                    this.multiLinesComments.add(node);
                }
                this.detectImplementations(node);
                this.detectExtensions(node);
            }
            for (IFunction function : this.functions) {
                if (!this.name.toString().equals(function.getName())) continue;
                this.constructor = function;
            }
        }
        return this;
    }

    @Override
    public List<IMetaData> getAllMetaData() {
        ArrayList<IMetaData> list = new ArrayList<IMetaData>();
        for (Map.Entry<MetaData, List<IMetaData>> entry : this.metaDataList.entrySet()) {
            list.addAll((Collection<IMetaData>)entry.getValue());
        }
        return list;
    }

    @Override
    public IParserNode getAsDoc() {
        return this.asDoc;
    }

    @Override
    public List<IAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public double getAverageCyclomaticComplexity() {
        if (this.functions.isEmpty()) {
            return 0.0;
        }
        int totalCcn = 0;
        for (IFunction function : this.functions) {
            totalCcn += function.getCyclomaticComplexity();
        }
        return totalCcn / this.functions.size();
    }

    @Override
    public final IParserNode getBlock() {
        return this.block;
    }

    @Override
    public List<IConstant> getConstants() {
        return this.constants;
    }

    @Override
    public IFunction getConstructor() {
        return this.constructor;
    }

    @Override
    public String getExtensionName() {
        return this.extensionName;
    }

    @Override
    public List<IFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public List<IParserNode> getImplementations() {
        return this.implementations;
    }

    @Override
    public List<IMetaData> getMetaData(MetaData metaDataName) {
        if (this.metaDataList.containsKey((Object)metaDataName)) {
            return this.metaDataList.get((Object)metaDataName);
        }
        return new ArrayList<IMetaData>();
    }

    @Override
    public int getMetaDataCount() {
        return this.metaDataList.size();
    }

    @Override
    public List<IParserNode> getMultiLinesComment() {
        return this.multiLinesComments;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public boolean is(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    @Override
    public boolean isBindable() {
        return this.metaDataList.get((Object)MetaData.BINDABLE) != null;
    }

    @Override
    public boolean isFinal() {
        return this.is(Modifier.FINAL);
    }

    @Override
    public boolean isPublic() {
        return this.is(Modifier.PUBLIC);
    }

    private void computeClassContent(IParserNode classContentNode) {
        if (classContentNode.numChildren() != 0) {
            for (IParserNode node : classContentNode.getChildren()) {
                this.detectBlock(node);
                this.detectFunction(node);
                this.detectAttribute(node);
                this.detectConstant(node);
                if (!node.is(NodeKind.MULTI_LINE_COMMENT)) continue;
                this.multiLinesComments.add(node);
            }
        }
    }

    private void detectAttribute(IParserNode node) {
        if (node.is(NodeKind.VAR_LIST)) {
            this.attributes.add(new AttributeNode(node).compute());
        }
    }

    private void detectBlock(IParserNode node) {
        if (node.is(NodeKind.BLOCK)) {
            this.block = node;
        }
    }

    private void detectConstant(IParserNode node) {
        if (node.is(NodeKind.CONST_LIST)) {
            this.constants.add(new ConstantNode(node).compute());
        }
    }

    private void detectExtensions(IParserNode node) {
        if (node.is(NodeKind.EXTENDS)) {
            this.extensionName = node.getStringValue();
        }
    }

    private void detectFunction(IParserNode node) {
        if (node.is(NodeKind.FUNCTION) || node.is(NodeKind.GET) || node.is(NodeKind.SET)) {
            this.functions.add(new FunctionNode(node).compute());
        }
    }

    private void detectImplementations(IParserNode node) {
        if (node.is(NodeKind.IMPLEMENTS_LIST)) {
            this.implementations = node.getChildren();
        }
    }
}

