/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.nodes.impl;

import com.adobe.ac.pmd.nodes.IMetaDataListHolder;
import com.adobe.ac.pmd.nodes.IModifiersHolder;
import com.adobe.ac.pmd.nodes.INode;
import com.adobe.ac.pmd.nodes.Modifier;
import com.adobe.ac.pmd.nodes.impl.NodeFactory;
import com.adobe.ac.pmd.parser.IParserNode;
import java.util.logging.Logger;

abstract class AbstractNode
implements INode {
    protected static final Logger LOGGER = Logger.getLogger("Node");
    private final IParserNode internalNode;

    protected static void computeMetaDataList(IMetaDataListHolder metaDataHolder, IParserNode child) {
        if (child.numChildren() != 0) {
            for (IParserNode metadataNode : child.getChildren()) {
                metaDataHolder.add(NodeFactory.createMetaData(metadataNode));
            }
        }
    }

    protected static final void computeModifierList(IModifiersHolder modifiable, IParserNode child) {
        if (child.numChildren() != 0) {
            for (IParserNode modifierNode : child.getChildren()) {
                Modifier modifier = Modifier.create(modifierNode.getStringValue());
                modifiable.add(modifier);
            }
        }
    }

    protected AbstractNode(IParserNode node) {
        this.internalNode = node;
    }

    public abstract AbstractNode compute();

    public IParserNode getInternalNode() {
        return this.internalNode;
    }
}

