/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.files;

import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.nodes.IPackage;
import com.adobe.ac.pmd.nodes.impl.NodeFactory;
import com.adobe.ac.pmd.parser.IParserNode;
import com.adobe.ac.pmd.parser.exceptions.TokenException;
import de.bokelberg.flex.parser.AS3Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSetUtils {
    private static final ThreadPoolExecutor EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);
    private static final Logger LOGGER = Logger.getLogger(FileSetUtils.class.getName());

    public static IParserNode buildAst(IFlexFile file) throws PMDException {
        IParserNode rootNode = null;
        try {
            rootNode = FileSetUtils.tryToBuildAst(file);
        }
        catch (IOException e) {
            throw new PMDException("While building AST: Cannot read " + file.getFullyQualifiedName(), (Exception)e);
        }
        catch (TokenException e) {
            throw new PMDException("TokenException thrown while building AST on " + file.getFullyQualifiedName() + " with message: " + e.getMessage(), (Exception)((Object)e));
        }
        return rootNode;
    }

    public static IParserNode buildThreadedAst(final IFlexFile file) throws PMDException, InterruptedException, ExecutionException {
        ArrayList<1> toRun = new ArrayList<1>();
        toRun.add(new Callable<Object>(){

            @Override
            public Object call() throws PMDException {
                return FileSetUtils.buildAst(file);
            }
        });
        List futures = EXECUTOR.invokeAll(toRun, 5L, TimeUnit.SECONDS);
        return (IParserNode)futures.get(0).get();
    }

    public static Map<String, IPackage> computeAsts(Map<String, IFlexFile> files) throws PMDException {
        LOGGER.setLevel(Level.SEVERE);
        LinkedHashMap<String, IPackage> asts = new LinkedHashMap<String, IPackage>();
        for (Map.Entry<String, IFlexFile> fileEntry : files.entrySet()) {
            IFlexFile file = fileEntry.getValue();
            try {
                IParserNode node = FileSetUtils.buildThreadedAst(file);
                asts.put(file.getFullyQualifiedName(), NodeFactory.createPackage(node));
            }
            catch (InterruptedException e) {
                LOGGER.warning(FileSetUtils.buildLogMessage(file, e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warning(FileSetUtils.buildLogMessage(file, e.getMessage()));
            }
            catch (ExecutionException e) {
                LOGGER.warning(FileSetUtils.buildLogMessage(file, e.getMessage()));
            }
            catch (CancellationException e) {
                LOGGER.warning(FileSetUtils.buildLogMessage(file, e.getMessage()));
            }
        }
        return asts;
    }

    protected static String buildLogMessage(IFlexFile file, String message) {
        return "While building AST on " + file.getFullyQualifiedName() + ", an error occured: " + message;
    }

    private static IParserNode tryToBuildAst(IFlexFile file) throws IOException, TokenException {
        AS3Parser parser = new AS3Parser();
        IParserNode rootNode = file instanceof IMxmlFile ? parser.buildAst(file.getFilePath(), ((IMxmlFile)file).getScriptBlock()) : parser.buildAst(file.getFilePath());
        return rootNode;
    }

    private FileSetUtils() {
    }
}

