/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.cpd.ant;

import com.adobe.ac.cpd.FlexLanguage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.FileReporter;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.ReportException;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FlexCpdAntTask
extends Task {
    private String encoding = System.getProperty("file.encoding");
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private int minimumTokenCount = 25;
    private File outputFile;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() {
        try {
            this.validateFields();
            this.log("Starting run, minimumTokenCount is " + this.minimumTokenCount, 2);
            this.log("Tokenizing files", 2);
            CPD cpd = new CPD(this.minimumTokenCount, (Language)new FlexLanguage());
            cpd.setEncoding(this.encoding);
            this.tokenizeFiles(cpd);
            this.log("Starting to analyze code", 2);
            long timeTaken = this.analyzeCode(cpd);
            this.log("Done analyzing code; that took " + timeTaken + " milliseconds");
            this.log("Generating report", 2);
            this.report(cpd);
        }
        catch (IOException ioe) {
            this.log(ioe.toString(), 0);
            throw new BuildException("IOException during task execution", (Throwable)ioe);
        }
        catch (ReportException re) {
            this.log(re.toString(), 0);
            throw new BuildException("ReportException during task execution", (Throwable)re);
        }
    }

    public void setEncoding(String encodingValue) {
        this.encoding = encodingValue;
    }

    public void setMinimumTokenCount(int minimumTokenCountToBeSet) {
        this.minimumTokenCount = minimumTokenCountToBeSet;
    }

    public void setOutputFile(File outputFileToBeSet) {
        this.outputFile = outputFileToBeSet;
    }

    private long analyzeCode(CPD cpd) {
        long start = System.currentTimeMillis();
        cpd.go();
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    private File getFile(DirectoryScanner directoryScanner, String includedFile) {
        File file = new File(directoryScanner.getBasedir() + System.getProperty("file.separator") + includedFile);
        this.log("Tokenizing " + file.getAbsolutePath(), 3);
        return file;
    }

    private void report(CPD cpd) throws ReportException {
        XMLRenderer renderer = new XMLRenderer(this.encoding);
        FileReporter reporter = this.outputFile == null ? new FileReporter(this.encoding) : (this.outputFile.isAbsolute() ? new FileReporter(this.outputFile, this.encoding) : new FileReporter(new File(this.getProject().getBaseDir(), this.outputFile.toString()), this.encoding));
        reporter.report(renderer.render(cpd.getMatches()));
    }

    private void tokenizeFiles(CPD cpd) throws IOException {
        for (FileSet fileSet : this.filesets) {
            String[] includedFiles;
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                cpd.add(this.getFile(directoryScanner, includedFile));
            }
        }
    }

    private void validateFields() {
        if (this.minimumTokenCount == 0) {
            throw new BuildException("minimumTokenCount is required and must be greater than zero");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("Must include at least one FileSet");
        }
    }
}

