/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.files.impl;

import com.adobe.ac.pmd.files.IMxmlFile;
import com.adobe.ac.pmd.files.impl.AbstractFlexFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MxmlFile
extends AbstractFlexFile
implements IMxmlFile {
    private String[] actualScriptBlock;
    private int endLine;
    private boolean mainApplication = false;
    private String[] scriptBlock;
    private int startLine;

    protected MxmlFile(File file, File rootDirectory) {
        super(file, rootDirectory);
        this.computeIfIsMainApplication();
        if (this.getLinesNb() > 0) {
            this.extractScriptBlock();
        }
    }

    @Override
    public final String[] getActualScriptBlock() {
        return this.actualScriptBlock;
    }

    @Override
    public int getBeginningScriptBlock() {
        return this.startLine;
    }

    @Override
    public final String getCommentClosingTag() {
        return "-->";
    }

    @Override
    public final String getCommentOpeningTag() {
        return "<!--";
    }

    @Override
    public int getEndingScriptBlock() {
        return this.endLine;
    }

    @Override
    public final String[] getScriptBlock() {
        return this.scriptBlock;
    }

    @Override
    public String getSingleLineComment() {
        return this.getCommentOpeningTag();
    }

    @Override
    public final boolean isMainApplication() {
        return this.mainApplication;
    }

    @Override
    public final boolean isMxml() {
        return true;
    }

    private void computeIfIsMainApplication() {
        for (String line : this.getLines()) {
            if (!line.contains("Application ") || line.charAt(0) != '<') continue;
            this.mainApplication = true;
            break;
        }
    }

    private int computeScriptOffSet(int startingLineIndex) {
        int currentLineIndex = startingLineIndex + 1;
        while (this.getLines().get(currentLineIndex).contains("CDATA[") || this.getLines().get(currentLineIndex).contains("/*") || this.getLines().get(currentLineIndex).trim().equals("")) {
            ++currentLineIndex;
        }
        return currentLineIndex - startingLineIndex;
    }

    private void copyScriptLinesKeepingOriginalLineIndices() {
        List<String> scriptLines = this.fillMxmlLine();
        String firstLine = "package " + this.getPackageName() + "{";
        String secondLine = "class " + this.getClassName().split("\\.")[0] + "{";
        scriptLines.set(0, firstLine);
        scriptLines.set(1, secondLine);
        scriptLines.set(scriptLines.size() - 1, "}}");
        this.scriptBlock = scriptLines.toArray(new String[scriptLines.size()]);
    }

    private void extractScriptBlock() {
        int currentLineIndex = 0;
        this.startLine = 0;
        this.endLine = 0;
        for (String line : this.getLines()) {
            if (line.contains("Script>")) {
                if (line.contains("</")) {
                    this.endLine = currentLineIndex - 1;
                    break;
                }
                if (line.contains("<")) {
                    this.startLine = currentLineIndex + this.computeScriptOffSet(currentLineIndex);
                }
            }
            ++currentLineIndex;
        }
        this.copyScriptLinesKeepingOriginalLineIndices();
    }

    private List<String> fillMxmlLine() {
        int j;
        ArrayList<String> scriptLines = new ArrayList<String>();
        for (j = 0; j < this.startLine; ++j) {
            scriptLines.add("");
        }
        if (this.startLine < this.endLine) {
            this.actualScriptBlock = this.getLines().subList(this.startLine, this.endLine).toArray(new String[this.endLine - this.startLine]);
            scriptLines.addAll(new ArrayList<String>(this.getLines().subList(this.startLine, this.endLine)));
        }
        for (j = this.endLine; j < this.getLines().size(); ++j) {
            scriptLines.add("");
        }
        return scriptLines;
    }
}

