/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.files.impl;

import com.adobe.ac.ncss.filters.FlexFilter;
import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.impl.AbstractFlexFile;
import com.adobe.ac.pmd.files.impl.As3File;
import com.adobe.ac.pmd.files.impl.MxmlFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    public static Map<String, IFlexFile> computeFilesList(File source, List<File> sourceList, String packageToExclude, List<String> excludePatterns) throws PMDException {
        LinkedHashMap<String, IFlexFile> files = new LinkedHashMap<String, IFlexFile>();
        FlexFilter flexFilter = new FlexFilter();
        Collection<File> foundFiles = FileUtils.getFlexFiles(source, sourceList, flexFilter);
        for (File sourceFile : foundFiles) {
            AbstractFlexFile file = FileUtils.create(sourceFile, source);
            if (!"".equals(packageToExclude) && file.getFullyQualifiedName().startsWith(packageToExclude) || FileUtils.currentPackageIncludedInExcludePatterns(file.getFullyQualifiedName(), excludePatterns)) continue;
            files.put(file.getFullyQualifiedName(), file);
        }
        return files;
    }

    public static AbstractFlexFile create(File sourceFile, File sourceDirectory) {
        AbstractFlexFile file = sourceFile.getName().endsWith(".as") ? new As3File(sourceFile, sourceDirectory) : new MxmlFile(sourceFile, sourceDirectory);
        return file;
    }

    public static String[] readLines(File file) throws IOException {
        List lines = com.adobe.ac.ncss.utils.FileUtils.readFile((File)file);
        return lines.toArray(new String[lines.size()]);
    }

    private static boolean currentPackageIncludedInExcludePatterns(String fullyQualifiedName, List<String> excludePatterns) {
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                if (!fullyQualifiedName.startsWith(excludePattern)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<File> getFlexFiles(File source, List<File> sourceList, FlexFilter flexFilter) throws PMDException {
        Collection<File> foundFiles;
        if (source == null && sourceList == null) {
            throw new PMDException("sourceDirectory is empty", null);
        }
        if (source == null) {
            foundFiles = com.adobe.ac.ncss.utils.FileUtils.listFiles(sourceList, (FilenameFilter)flexFilter, (boolean)true);
        } else if (source.isDirectory()) {
            foundFiles = com.adobe.ac.ncss.utils.FileUtils.listFiles((File)source, (FilenameFilter)flexFilter, (boolean)true);
        } else {
            foundFiles = new ArrayList();
            foundFiles.add(source);
        }
        if (foundFiles.isEmpty()) {
            return new ArrayList<File>();
        }
        return foundFiles;
    }

    private FileUtils() {
    }
}

