/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.files.impl;

import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.utils.StackTraceUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFlexFile
implements IFlexFile {
    private static final Logger LOGGER = Logger.getLogger(AbstractFlexFile.class.getName());
    private final String className;
    private final File file;
    private final List<String> lines;
    private final String packageName;

    private static boolean doesCurrentLineContain(String line, String search) {
        return line.contains(search);
    }

    protected AbstractFlexFile(File underlyingFile, File rootDirectory) {
        String filePath = underlyingFile.getPath();
        String rootPath = rootDirectory.getPath();
        this.file = underlyingFile;
        this.className = underlyingFile.getName();
        this.packageName = this.computePackageName(filePath, rootPath);
        this.lines = new ArrayList<String>();
        try {
            String[] linesArray;
            for (String string : linesArray = FileUtils.readLines(underlyingFile)) {
                this.lines.add(string);
            }
        }
        catch (IOException e) {
            LOGGER.warning(StackTraceUtils.print((Exception)e));
        }
    }

    @Override
    public final boolean contains(String stringToLookup, Set<Integer> linesToBeIgnored) {
        int lineIndex = 1;
        boolean found = false;
        for (String line : this.lines) {
            if (AbstractFlexFile.doesCurrentLineContain(line, stringToLookup) && !linesToBeIgnored.contains(lineIndex)) {
                found = true;
                break;
            }
            ++lineIndex;
        }
        return found;
    }

    public final boolean equals(Object obj) {
        return this.hashCode() == ((AbstractFlexFile)obj).hashCode();
    }

    @Override
    public final String getClassName() {
        return this.className;
    }

    @Override
    public abstract String getCommentClosingTag();

    @Override
    public abstract String getCommentOpeningTag();

    @Override
    public final String getFilename() {
        return this.file.getName();
    }

    @Override
    public final String getFilePath() {
        return this.file.toURI().getPath();
    }

    @Override
    public final String getFullyQualifiedName() {
        return (StringUtils.isEmpty((String)this.packageName) ? "" : this.packageName + ".") + this.className;
    }

    @Override
    public String getLineAt(int lineIndex) {
        return this.lines.get(lineIndex - 1);
    }

    public final List<String> getLines() {
        return this.lines;
    }

    @Override
    public int getLinesNb() {
        return this.lines.size();
    }

    @Override
    public final String getPackageName() {
        return this.packageName;
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    @Override
    public abstract boolean isMainApplication();

    @Override
    public abstract boolean isMxml();

    private String computePackageName(String filePath, CharSequence rootPath) {
        String temporaryPackage = filePath.replace(this.className, "").replace(rootPath, "").replace(System.getProperty("file.separator"), ".");
        if (temporaryPackage.endsWith(".")) {
            temporaryPackage = temporaryPackage.substring(0, temporaryPackage.length() - 1);
        }
        if (temporaryPackage.length() > 0 && temporaryPackage.charAt(0) == '.') {
            temporaryPackage = temporaryPackage.substring(1, temporaryPackage.length());
        }
        return temporaryPackage;
    }
}

