/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd;

import com.adobe.ac.pmd.files.IFlexFile;
import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.utils.StackTraceUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcesManagerTest {
    private static ResourcesManagerTest instance = null;
    private static final Logger LOGGER = Logger.getLogger(ResourcesManagerTest.class.getName());
    private final Map<String, IFlexFile> testFiles;
    private final File testRootDirectory;

    public static synchronized ResourcesManagerTest getInstance() {
        if (instance == null) {
            try {
                LOGGER.setLevel(Level.WARNING);
                instance = new ResourcesManagerTest("/test");
            }
            catch (URISyntaxException e) {
                LOGGER.warning(StackTraceUtils.print((Exception)e));
            }
            catch (PMDException e) {
                LOGGER.warning(StackTraceUtils.print((Exception)e));
            }
        }
        return instance;
    }

    private ResourcesManagerTest(String directory) throws URISyntaxException, PMDException {
        URL resource = this.getClass().getResource(directory);
        if (resource == null) {
            LOGGER.severe("/test folder is not found in the resource");
            this.testRootDirectory = null;
            this.testFiles = new LinkedHashMap<String, IFlexFile>();
        } else {
            this.testRootDirectory = new File(resource.toURI().getPath());
            this.testFiles = FileUtils.computeFilesList(this.testRootDirectory, null, "", null);
        }
    }

    public Map<String, IFlexFile> getTestFiles() {
        return this.testFiles;
    }

    protected File getTestRootDirectory() {
        return this.testRootDirectory;
    }
}

