/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.ant;

import com.adobe.ac.pmd.FlexPmdParameters;
import com.adobe.ac.pmd.FlexPmdViolations;
import com.adobe.ac.pmd.engines.FlexPmdXmlEngine;
import com.adobe.ac.pmd.engines.PmdEngineUtils;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FlexPmdAntTask
extends Task {
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private File outputDirectory;
    private String packageToExclude;
    private File ruleSet;
    private File sourceDirectory;

    public final void execute() {
        try {
            String message;
            this.presetParameters();
            FlexPmdXmlEngine engine = new FlexPmdXmlEngine(new FlexPmdParameters(this.packageToExclude, this.outputDirectory, this.ruleSet, this.sourceDirectory));
            FlexPmdViolations violations = new FlexPmdViolations();
            engine.executeReport(violations);
            if (this.failOnError && (message = PmdEngineUtils.findFirstViolationError((FlexPmdViolations)violations)).length() > 0) {
                throw new BuildException(message);
            }
            if (this.failOnRuleViolation && !violations.getViolations().isEmpty()) {
                throw new BuildException("At least one violation has been found");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public final String getPackageToExclude() {
        return this.packageToExclude;
    }

    public final void setFailOnError(boolean failOnErrorToBeSet) {
        this.failOnError = failOnErrorToBeSet;
    }

    public final void setFailOnRuleViolation(boolean failOnRuleViolation) {
        this.failOnRuleViolation = failOnRuleViolation;
    }

    public final void setOutputDirectory(File outputDirectoryToBeSet) {
        this.outputDirectory = outputDirectoryToBeSet;
    }

    public final void setPackageToExclude(String packageToExcludeToBeSet) {
        this.packageToExclude = packageToExcludeToBeSet;
    }

    public final void setRuleSet(File ruleSetToBeSet) {
        this.ruleSet = ruleSetToBeSet;
    }

    public final void setSourceDirectory(File sourceDirectoryToBeSet) {
        this.sourceDirectory = sourceDirectoryToBeSet;
    }

    private void presetParameters() {
        if (this.packageToExclude == null) {
            this.packageToExclude = "";
        }
    }
}

