/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics.engine;

import com.adobe.ac.ncss.filters.FlexFilter;
import com.adobe.ac.pmd.files.FileSetUtils;
import com.adobe.ac.pmd.files.impl.AbstractFlexFile;
import com.adobe.ac.pmd.files.impl.FileUtils;
import com.adobe.ac.pmd.metrics.AverageClassMetrics;
import com.adobe.ac.pmd.metrics.AverageFunctionMetrics;
import com.adobe.ac.pmd.metrics.ClassMetrics;
import com.adobe.ac.pmd.metrics.InternalFunctionMetrics;
import com.adobe.ac.pmd.metrics.MetricUtils;
import com.adobe.ac.pmd.metrics.PackageMetrics;
import com.adobe.ac.pmd.metrics.ProjectMetrics;
import com.adobe.ac.pmd.metrics.TotalPackageMetrics;
import com.adobe.ac.pmd.metrics.engine.AbstractMetrics;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.IPackage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlexMetrics
extends AbstractMetrics {
    private static final FlexFilter FLEX_FILTER = new FlexFilter();
    private static final Logger LOGGER = Logger.getLogger(FlexMetrics.class.getName());
    private final Map<String, IPackage> asts = this.initAst();

    public FlexMetrics(File sourceDirectoryPath) {
        super(sourceDirectoryPath);
    }

    @Override
    public ProjectMetrics loadMetrics() {
        ProjectMetrics metrics = new ProjectMetrics();
        for (File directory : this.getNonEmptyDirectories()) {
            Collection classesInPackage = com.adobe.ac.ncss.utils.FileUtils.listFiles((File)directory, (FilenameFilter)FLEX_FILTER, (boolean)false);
            if (!directory.isDirectory() || classesInPackage.isEmpty()) continue;
            String packageFullName = MetricUtils.getQualifiedName(this.getSourceDirectory(), directory);
            int functionsInPackage = 0;
            int ncssInPackage = 0;
            int asDocsInPackage = 0;
            int multipleLineCommentInPackage = 0;
            boolean importsInPackage = false;
            for (File fileInPackage : classesInPackage) {
                IClass classNode = null;
                InternalFunctionMetrics functionMetrics = null;
                AbstractFlexFile file = FileUtils.create((File)fileInPackage, (File)this.getSourceDirectory());
                if (this.asts.containsKey(file.getFullyQualifiedName()) && this.asts.get(file.getFullyQualifiedName()).getClassNode() != null) {
                    classNode = this.asts.get(file.getFullyQualifiedName()).getClassNode();
                    functionsInPackage += classNode.getFunctions().size();
                    functionMetrics = InternalFunctionMetrics.create(metrics, packageFullName, classNode);
                    asDocsInPackage += functionMetrics.getAsDocsInClass();
                    multipleLineCommentInPackage += functionMetrics.getMultipleLineCommentInClass();
                    ncssInPackage += functionMetrics.getNcssInClass();
                }
                ClassMetrics classMetrics = ClassMetrics.create(packageFullName, fileInPackage, functionMetrics, classNode);
                asDocsInPackage += classMetrics.getAsDocs();
                multipleLineCommentInPackage += classMetrics.getMultiLineComments();
                metrics.getClassMetrics().add(classMetrics);
            }
            metrics.getPackageMetrics().add(PackageMetrics.create(classesInPackage, packageFullName, functionsInPackage, ncssInPackage, asDocsInPackage, multipleLineCommentInPackage, 0));
        }
        this.setFinalMetrics(metrics);
        return metrics;
    }

    private Map<String, IPackage> initAst() {
        Map<String, Object> result = new HashMap<String, IPackage>();
        try {
            result = FileSetUtils.computeAsts((Map)FileUtils.computeFilesList((File)this.getSourceDirectory(), null, (String)"", null));
        }
        catch (PMDException e) {
            LOGGER.warning(e.getMessage());
        }
        return result;
    }

    private void setFinalMetrics(ProjectMetrics metrics) {
        metrics.setTotalPackages(TotalPackageMetrics.create(metrics.getPackageMetrics()));
        metrics.setAverageFunctions(AverageFunctionMetrics.create(metrics.getFunctionMetrics(), metrics.getTotalPackages()));
        metrics.setAverageObjects(AverageClassMetrics.create(metrics.getClassMetrics(), metrics.getTotalPackages()));
    }
}

