/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics.engine;

import com.adobe.ac.ncss.filters.FlexFilter;
import com.adobe.ac.pmd.metrics.ClassMetrics;
import com.adobe.ac.pmd.metrics.FunctionMetrics;
import com.adobe.ac.pmd.metrics.PackageMetrics;
import com.adobe.ac.pmd.metrics.ProjectMetrics;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetrics {
    private Collection<File> nonEmptyDirectories = null;
    private File sourceDirectory = null;

    private static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(AbstractMetrics.listFiles(entry, filter, recurse));
        }
        return files;
    }

    private static Collection<File> listNonEmptyDirectories(File rootDirectory, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        File[] entries = rootDirectory.listFiles(new DirectoryFilter());
        FlexFilter flexFilter = new FlexFilter();
        for (File entry : entries) {
            if (entry.isDirectory() && !AbstractMetrics.listFiles(entry, (FilenameFilter)flexFilter, false).isEmpty()) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(AbstractMetrics.listNonEmptyDirectories(entry, recurse));
        }
        return files;
    }

    public AbstractMetrics(File sourceDirectoryPath) {
        if (sourceDirectoryPath != null) {
            this.nonEmptyDirectories = AbstractMetrics.listNonEmptyDirectories(sourceDirectoryPath, true);
            this.nonEmptyDirectories.add(sourceDirectoryPath);
            this.sourceDirectory = sourceDirectoryPath;
        }
    }

    public void execute(File outputFile) throws DocumentException, IOException {
        String builtReport = this.buildReport(this.loadMetrics());
        Document document = DocumentHelper.parseText((String)builtReport);
        OutputFormat format = OutputFormat.createPrettyPrint();
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(outputFile), format);
        writer.write(document);
        writer.close();
    }

    public abstract ProjectMetrics loadMetrics();

    protected Collection<File> getNonEmptyDirectories() {
        return this.nonEmptyDirectories;
    }

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    private String addFunctions(ProjectMetrics metrics) {
        StringBuffer buffer = new StringBuffer(250);
        buffer.append("<functions>");
        for (FunctionMetrics functionMetrics : metrics.getFunctions()) {
            buffer.append(functionMetrics.toXmlString());
        }
        buffer.append(MessageFormat.format("<function_averages><ncss>{0}</ncss><javadocs>{1}</javadocs><javadoc_lines>{1}</javadoc_lines><single_comment_lines>0</single_comment_lines><multi_comment_lines>0</multi_comment_lines></function_averages><ncss>{2}</ncss></functions>", String.valueOf(metrics.getAverageFunctions().getAverageStatements()), String.valueOf(metrics.getAverageFunctions().getAverageDocs()), String.valueOf(metrics.getTotalPackages().getTotalStatements())));
        return buffer.toString();
    }

    private String addObjects(ProjectMetrics metrics) {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("<objects>");
        for (ClassMetrics classMetrics : metrics.getClasses()) {
            buffer.append(classMetrics.toXmlString());
        }
        buffer.append(MessageFormat.format("<averages><classes>{0}</classes><functions>{1}</functions><ncss>{2}</ncss><javadocs>{3}</javadocs><javadoc_lines>{3}</javadoc_lines><single_comment_lines>0</single_comment_lines><multi_comment_lines>0</multi_comment_lines></averages><ncss>{4}</ncss></objects>", String.valueOf(metrics.getClasses().size()), String.valueOf(metrics.getAverageObjects().getAverageFunctions()), String.valueOf(metrics.getAverageObjects().getAverageStatements()), String.valueOf(metrics.getAverageObjects().getAverageDocs()), String.valueOf(metrics.getTotalPackages().getTotalStatements())));
        return buffer.toString();
    }

    private String addPackages(ProjectMetrics metrics) {
        StringBuffer buffer = new StringBuffer(228);
        buffer.append("<packages>");
        for (PackageMetrics packageMetrics : metrics.getPackages()) {
            buffer.append(packageMetrics.toXmlString());
        }
        buffer.append(metrics.getTotalPackages().getContreteXml());
        buffer.append("</packages>");
        return buffer.toString();
    }

    private String buildReport(ProjectMetrics metrics) {
        StringBuffer buf = new StringBuffer(70);
        buf.append("<?xml version=\"1.0\"?><javancss><date>" + metrics.getDate() + "</date><time>" + metrics.getTime() + "</time>");
        buf.append(this.addPackages(metrics));
        buf.append(this.addObjects(metrics));
        buf.append(this.addFunctions(metrics));
        buf.append("</javancss>");
        return buf.toString();
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

