/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.metrics.IMetrics;
import com.adobe.ac.pmd.metrics.PackageMetrics;
import java.text.MessageFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TotalPackageMetrics
implements IMetrics {
    private final int totalAsDocs;
    private final int totalClasses;
    private final int totalFunctions;
    private final int totalMultiLineComment;
    private final int totalStatements;

    public static TotalPackageMetrics create(List<PackageMetrics> packageMetrics) {
        int nonCommentStatement = 0;
        int functions = 0;
        int classes = 0;
        int asDocs = 0;
        int multipleLineComments = 0;
        for (PackageMetrics metrics : packageMetrics) {
            nonCommentStatement += metrics.getNonCommentStatements();
            functions += metrics.getFunctions();
            classes += metrics.getClasses();
            asDocs += metrics.getAsDocs();
            multipleLineComments += metrics.getMultiLineComments();
        }
        return new TotalPackageMetrics(nonCommentStatement, functions, classes, asDocs, multipleLineComments);
    }

    private TotalPackageMetrics(int totalStatementsToBeSet, int totalFunctionsToBeSet, int totalClassesToBeSet, int totalAsDocsToBeSet, int totalMultiLineCommentToBeSet) {
        this.totalStatements = totalStatementsToBeSet;
        this.totalFunctions = totalFunctionsToBeSet;
        this.totalClasses = totalClassesToBeSet;
        this.totalAsDocs = totalAsDocsToBeSet;
        this.totalMultiLineComment = totalMultiLineCommentToBeSet;
    }

    @Override
    public String getContreteXml() {
        return new StringBuffer().append(MessageFormat.format("<total><classes>{0}</classes><functions>{1}</functions><ncss>{2}</ncss><javadocs>{3}</javadocs><javadoc_lines>{3}</javadoc_lines><single_comment_lines>0</single_comment_lines><multi_comment_lines>{4}</multi_comment_lines></total>", String.valueOf(this.totalClasses), String.valueOf(this.totalFunctions), String.valueOf(this.totalStatements), String.valueOf(this.totalAsDocs), String.valueOf(this.totalMultiLineComment))).toString();
    }

    public int getTotalAsDocs() {
        return this.totalAsDocs;
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    public int getTotalFunctions() {
        return this.totalFunctions;
    }

    public int getTotalMultiLineComment() {
        return this.totalMultiLineComment;
    }

    public int getTotalStatements() {
        return this.totalStatements;
    }
}

