/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.metrics.AbstractPackagedMetrics;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageMetrics
extends AbstractPackagedMetrics {
    private final int classes;
    private final int functions;
    private final int imports;

    public static PackageMetrics create(Collection<File> classesInPackage, String packageFullName, int functionsInPackage, int ncssInPackage, int asDocsInPackage, int multipleLineCommentInPackage, int imports) {
        return new PackageMetrics(ncssInPackage, functionsInPackage, classesInPackage.size(), packageFullName, asDocsInPackage, multipleLineCommentInPackage, imports);
    }

    private PackageMetrics(int nonCommentStatements, int functionsToBeSet, int classesToBeSet, String packageName, int asDocs, int multiLineComments, int importsToBeSet) {
        super(nonCommentStatements, packageName, 0, asDocs, multiLineComments);
        this.functions = functionsToBeSet;
        this.classes = classesToBeSet;
        this.imports = importsToBeSet;
    }

    public int getClasses() {
        return this.classes;
    }

    @Override
    public String getContreteXml() {
        return new StringBuffer().append(MessageFormat.format("<functions>{0}</functions><classes>{1}</classes>", String.valueOf(this.functions), String.valueOf(this.classes))).toString();
    }

    @Override
    public String getFullName() {
        return this.getPackageName();
    }

    public int getFunctions() {
        return this.functions;
    }

    @Override
    public String getMetricsName() {
        return "package";
    }

    @Override
    protected int getNcss() {
        return this.imports + 1;
    }
}

