/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.nodes.IAsDocHolder;
import com.adobe.ac.pmd.nodes.ICommentHolder;
import com.adobe.ac.pmd.parser.IParserNode;
import java.io.File;

public final class MetricUtils {
    public static int computeAsDocs(IAsDocHolder attribute) {
        return attribute.getAsDoc() == null ? 0 : MetricUtils.computeNbOfLines(attribute.getAsDoc().getStringValue());
    }

    public static int computeMultiLineComments(ICommentHolder commentHolder) {
        int lines = 0;
        for (IParserNode comment : commentHolder.getMultiLinesComment()) {
            lines += comment.getStringValue() == null ? 0 : MetricUtils.computeNbOfLines(comment.getStringValue());
        }
        return lines;
    }

    public static int computeNbOfLines(String lines) {
        return lines.split("\\n").length;
    }

    public static String getQualifiedName(File sourceDirectory, File file) {
        String qualifiedName = file.getAbsolutePath().replace(sourceDirectory.getAbsolutePath(), "").replace("/", ".").replace("\\", ".").trim();
        if (qualifiedName.length() > 0 && qualifiedName.charAt(0) == '.') {
            return qualifiedName.substring(1);
        }
        return qualifiedName;
    }

    private MetricUtils() {
    }
}

