/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.metrics.FunctionMetrics;
import com.adobe.ac.pmd.metrics.MetricUtils;
import com.adobe.ac.pmd.metrics.ProjectMetrics;
import com.adobe.ac.pmd.nodes.IAsDocHolder;
import com.adobe.ac.pmd.nodes.IAttribute;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.ICommentHolder;
import com.adobe.ac.pmd.nodes.IFunction;
import com.adobe.ac.pmd.nodes.IMetaData;

public final class InternalFunctionMetrics {
    private final int asDocsInClass;
    private final int multipleLineCommentInClass;
    private final int ncssInClass;

    public static InternalFunctionMetrics create(ProjectMetrics metrics, String packageFullName, IClass classNode) {
        int ncssInClass = 0;
        int asDocsInClass = 0;
        int multipleLineCommentInClass = 0;
        for (IFunction function : classNode.getFunctions()) {
            int multipleDoc = MetricUtils.computeMultiLineComments((ICommentHolder)function);
            int asDocs = MetricUtils.computeAsDocs((IAsDocHolder)function);
            ncssInClass += function.getStatementNbInBody();
            multipleLineCommentInClass += multipleDoc;
            for (IMetaData metaData : function.getAllMetaData()) {
                asDocs += MetricUtils.computeAsDocs((IAsDocHolder)metaData);
            }
            asDocsInClass += asDocs;
            metrics.getFunctionMetrics().add(FunctionMetrics.create(packageFullName, classNode, function, asDocs, multipleDoc));
        }
        for (IAttribute attribute : classNode.getAttributes()) {
            asDocsInClass += MetricUtils.computeAsDocs((IAsDocHolder)attribute);
            for (IMetaData metaData : attribute.getAllMetaData()) {
                asDocsInClass += MetricUtils.computeAsDocs((IAsDocHolder)metaData);
            }
        }
        for (IMetaData metaData : classNode.getAllMetaData()) {
            asDocsInClass += MetricUtils.computeAsDocs((IAsDocHolder)metaData);
        }
        return new InternalFunctionMetrics(ncssInClass, asDocsInClass, multipleLineCommentInClass);
    }

    private InternalFunctionMetrics(int ncssInClassToBeSet, int asDocsInClassToBeSet, int multipleLineCommentInClassToBeSet) {
        this.ncssInClass = ncssInClassToBeSet;
        this.asDocsInClass = asDocsInClassToBeSet;
        this.multipleLineCommentInClass = multipleLineCommentInClassToBeSet;
    }

    public int getAsDocsInClass() {
        return this.asDocsInClass;
    }

    public int getMultipleLineCommentInClass() {
        return this.multipleLineCommentInClass;
    }

    public int getNcssInClass() {
        return this.ncssInClass;
    }
}

