/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.metrics.AbstractNamedMetrics;
import com.adobe.ac.pmd.metrics.InternalFunctionMetrics;
import com.adobe.ac.pmd.metrics.MetricUtils;
import com.adobe.ac.pmd.nodes.IClass;
import com.adobe.ac.pmd.nodes.ICommentHolder;
import java.io.File;

public final class ClassMetrics
extends AbstractNamedMetrics {
    private final IClass classNode;
    private final int functions;

    public static ClassMetrics create(String packageFullName, File fileInPackage, InternalFunctionMetrics functionMetrics, IClass classNodeToBeSet) {
        int average = classNodeToBeSet == null ? 0 : (int)Math.round(classNodeToBeSet.getAverageCyclomaticComplexity());
        int asDocs = (classNodeToBeSet == null || classNodeToBeSet.getAsDoc() == null ? 0 : MetricUtils.computeNbOfLines(classNodeToBeSet.getAsDoc().getStringValue())) + (functionMetrics == null ? 0 : functionMetrics.getAsDocsInClass());
        int multiLineComments = (classNodeToBeSet == null ? 0 : MetricUtils.computeMultiLineComments((ICommentHolder)classNodeToBeSet)) + (functionMetrics == null ? 0 : functionMetrics.getMultipleLineCommentInClass());
        return new ClassMetrics(functionMetrics == null ? 0 : functionMetrics.getNcssInClass(), classNodeToBeSet == null ? 0 : classNodeToBeSet.getFunctions().size(), fileInPackage.getName().replace(".as", ""), packageFullName, average, asDocs, multiLineComments, classNodeToBeSet);
    }

    private ClassMetrics(int nonCommentStatements, int functionsToBeSet, String name, String packageName, int ccn, int asDocs, int multiLineCommentsToBeSet, IClass classNodeToBeSet) {
        super(nonCommentStatements, name, packageName, ccn, asDocs, multiLineCommentsToBeSet);
        this.functions = functionsToBeSet;
        this.classNode = classNodeToBeSet;
    }

    public String getContreteXml() {
        return "<functions>" + this.functions + "</functions>";
    }

    public String getFullName() {
        return this.getPackageName().compareTo("") == 0 ? this.getName() : this.getPackageName() + "." + this.getName();
    }

    public int getFunctions() {
        return this.functions;
    }

    public String getMetricsName() {
        return "object";
    }

    protected int getNcss() {
        if (this.classNode == null) {
            return 1;
        }
        return 1 + this.classNode.getAttributes().size() + this.classNode.getConstants().size() + this.functions;
    }
}

