/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.pmd.metrics;

import com.adobe.ac.pmd.metrics.IMetrics;
import java.text.MessageFormat;

public abstract class AbstractPackagedMetrics
implements IMetrics {
    private final int asDocs;
    private final int ccn;
    private final int multiLineComments;
    private final int nonCommentStatements;
    private final String packageName;

    protected AbstractPackagedMetrics(int nonCommentStatementsToBeSet, String packageNameToBeSet, int ccnToBeSet, int asDocsToBeSet, int multiLineCommentsToBeSet) {
        this.nonCommentStatements = nonCommentStatementsToBeSet;
        this.packageName = packageNameToBeSet;
        this.ccn = ccnToBeSet;
        this.asDocs = asDocsToBeSet;
        this.multiLineComments = multiLineCommentsToBeSet;
    }

    public int getAsDocs() {
        return this.asDocs;
    }

    public abstract String getFullName();

    public abstract String getMetricsName();

    public int getMultiLineComments() {
        return this.multiLineComments;
    }

    public int getNonCommentStatements() {
        return this.getNcss() + this.nonCommentStatements;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toXmlString() {
        return new StringBuffer().append(MessageFormat.format("<{0}><name>{1}</name><ccn>{2}</ccn><ncss>{3}</ncss><javadocs>{4}</javadocs><javadoc_lines>{4}</javadoc_lines><multi_comment_lines>{5}</multi_comment_lines><single_comment_lines>0</single_comment_lines>{6}</{7}>", this.getMetricsName(), this.getFullName().equals("") ? "." : this.getFullName(), String.valueOf(this.ccn), String.valueOf(this.getNonCommentStatements()), String.valueOf(this.asDocs), String.valueOf(this.multiLineComments), this.getContreteXml(), this.getMetricsName())).toString();
    }

    protected abstract int getNcss();
}

