/*
 * File:			lm4f.lds
 * Author:		Yahia Farghaly <yahiafarghaly@gmail.com>.
 * Description:	Linker description file for Stellaris LM4FXXX microcontrollers.
 */

/*****************************************************************************
MIT License

Copyright (c) 2020 Yahia Farghaly Ashour

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
******************************************************************************/

OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(Reset_Handler) /* entry Point */

MEMORY {
    FLASH (rx)  : ORIGIN = 0x00000000, LENGTH = 256K
    RAM (rwx) : ORIGIN = 0x20000000, LENGTH = 32K
    STACK (rwx) : ORIGIN = 0x20007FFF , LENGTH = 0x00000000
}

/* The used stack size of the application. */
STACK_SIZE = 512;

/* The used heap size of the application. */
HEAP_SIZE = 0;

/*
* Sections Layout:
*
*
*	FLASH
*	-----------------
* 	| .NVIC_TABLE	|
* 	| .text*		|
* 	| .rodata*		|
*   | .data			|
* 	-----------------
*
* 	RAM
* 	-------------------------
* 	| .data* @ 0x20000000	|
* 	| .vtable				|
* 	| .bss*					|
* 	| .heap					|
* 	|						|
* 	|						|
* 	|						|
* 	| .stack @ 0x20007FFF 	|
* 	-------------------------
*
*/

SECTIONS {

    .text : {
     /* NVIC Vector Table must start @0x0 */
        KEEP(*(.NVIC_TABLE))
     /* Machine Instructions of your application code */
        *(.text)
        *(.text*)
     /* Read-only data */
        *(.rodata)
        *(.rodata*)
	/* For GNU ARM Linker to be happy about not overlapping .init LMA */
        KEEP (*(.init))
        KEEP (*(.fini))

        . = ALIGN(4);
    } >FLASH

	/* For GNU ARM Linker to be happy about not overlapping .init LMA */
    .preinit_array : {
        PROVIDE_HIDDEN (__preinit_array_start = .);
        KEEP (*(.preinit_array*))
        PROVIDE_HIDDEN (__preinit_array_end = .);
    } >FLASH

    .init_array : {
        PROVIDE_HIDDEN (__init_array_start = .);
        KEEP (*(SORT(.init_array.*)))
        KEEP (*(.init_array*))
        PROVIDE_HIDDEN (__init_array_end = .);
    } >FLASH

    .fini_array : {
        PROVIDE_HIDDEN (__fini_array_start = .);
        KEEP (*(.fini_array*))
        KEEP (*(SORT(.fini_array.*)))
        PROVIDE_HIDDEN (__fini_array_end = .);
    } >FLASH

	/* Store the end address of the .text section */
    _etext = .;

    .data :  AT (_etext) {				/* Places the .data section after the .text section directly. */
        __data_load = LOADADDR (.data); /* .data section start address in the FLASH Memory. */
        __data_start__ = .;				/* .data section start address in the RAM	Memory. */
        *(.data)
        *(.data*)
        *(vtable)           			/* vtable it's generated by stellarisware to store the NVIC table in ram */
        . = ALIGN(4);
        __data_end__ = .;
    } >RAM

    .bss : {
        __bss_start__ = .;
        *(.bss)
        *(.bss*)
        *(COMMON)
        . = ALIGN(4);
        __bss_end__ = .;
    } >RAM

    .heap : {
        __heap_start__ = .;
        . = . + HEAP_SIZE;
        . = ALIGN(4);
        __heap_end__ = .;
    } >RAM

    .stack : {
        __stack_start__ = .;	/* starts @ 0x20007FFF */
        __stack_end__ = . - STACK_SIZE;
    } >STACK

    /* Remove information from the standard libraries */
    /DISCARD/ : {
        libc.a ( * )
        libm.a ( * )
        libgcc.a ( * )
    }
}

 /* Check if FLASH usage exceeds FLASH size */
ASSERT( LENGTH(FLASH) >= (_etext + SIZEOF(.data)), "FLASH memory overflowed !")
ASSERT( STACK_SIZE >= (__stack_start__ - __stack_end__), "STACK memory overflowed !")
